/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.Player;
import androidx.media3.common.Tracks;
import androidx.media3.exoplayer.ExoPlayer;
import io.flutter.plugins.videoplayer.PlatformPlaybackState;
import io.flutter.plugins.videoplayer.VideoPlayerCallbacks;

public abstract class ExoPlayerEventListener
implements Player.Listener {
    private boolean isInitialized = false;
    protected final ExoPlayer exoPlayer;
    protected final VideoPlayerCallbacks events;

    public ExoPlayerEventListener(@NonNull ExoPlayer exoPlayer, @NonNull VideoPlayerCallbacks events) {
        this.exoPlayer = exoPlayer;
        this.events = events;
    }

    protected abstract void sendInitialized();

    public void onPlaybackStateChanged(int playbackState) {
        PlatformPlaybackState platformState = PlatformPlaybackState.UNKNOWN;
        switch (playbackState) {
            case 2: {
                platformState = PlatformPlaybackState.BUFFERING;
                break;
            }
            case 3: {
                platformState = PlatformPlaybackState.READY;
                if (this.isInitialized) break;
                this.isInitialized = true;
                this.sendInitialized();
                break;
            }
            case 4: {
                platformState = PlatformPlaybackState.ENDED;
                break;
            }
            case 1: {
                platformState = PlatformPlaybackState.IDLE;
            }
        }
        this.events.onPlaybackStateChanged(platformState);
    }

    public void onPlayerError(@NonNull PlaybackException error) {
        if (error.errorCode == 1002) {
            this.exoPlayer.seekToDefaultPosition();
            this.exoPlayer.prepare();
        } else {
            this.events.onError("VideoError", "Video player had error " + error, null);
        }
    }

    public void onIsPlayingChanged(boolean isPlaying) {
        this.events.onIsPlayingStateUpdate(isPlaying);
    }

    public void onTracksChanged(@NonNull Tracks tracks) {
        String selectedTrackId = this.findSelectedAudioTrackId(tracks);
        this.events.onAudioTrackChanged(selectedTrackId);
    }

    @Nullable
    private String findSelectedAudioTrackId(@NonNull Tracks tracks) {
        int groupIndex = 0;
        for (Tracks.Group group : tracks.getGroups()) {
            if (group.getType() == 1 && group.isSelected()) {
                for (int i = 0; i < group.length; ++i) {
                    if (!group.isTrackSelected(i)) continue;
                    return groupIndex + "_" + i;
                }
            }
            ++groupIndex;
        }
        return null;
    }

    protected static enum RotationDegrees {
        ROTATE_0(0),
        ROTATE_90(90),
        ROTATE_180(180),
        ROTATE_270(270);

        private final int degrees;

        private RotationDegrees(int degrees) {
            this.degrees = degrees;
        }

        public static RotationDegrees fromDegrees(int degrees) {
            for (RotationDegrees rotationDegrees : RotationDegrees.values()) {
                if (rotationDegrees.degrees != degrees) continue;
                return rotationDegrees;
            }
            throw new IllegalArgumentException("Invalid rotation degrees specified: " + degrees);
        }

        public int getDegrees() {
            return this.degrees;
        }
    }
}

