/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MediaSource;
import io.flutter.plugins.videoplayer.VideoAsset;
import java.util.Map;

final class HttpVideoAsset
extends VideoAsset {
    @NonNull
    private final VideoAsset.StreamingFormat streamingFormat;
    @NonNull
    private final Map<String, String> httpHeaders;
    @Nullable
    private final String userAgent;

    HttpVideoAsset(@Nullable String assetUrl, @NonNull VideoAsset.StreamingFormat streamingFormat, @NonNull Map<String, String> httpHeaders, @Nullable String userAgent) {
        super(assetUrl);
        this.streamingFormat = streamingFormat;
        this.httpHeaders = httpHeaders;
        this.userAgent = userAgent;
    }

    @Override
    @NonNull
    public MediaItem getMediaItem() {
        MediaItem.Builder builder = new MediaItem.Builder().setUri(this.assetUrl);
        String mimeType = null;
        switch (this.streamingFormat) {
            case SMOOTH: {
                mimeType = "application/vnd.ms-sstr+xml";
                break;
            }
            case DYNAMIC_ADAPTIVE: {
                mimeType = "application/dash+xml";
                break;
            }
            case HTTP_LIVE: {
                mimeType = "application/x-mpegURL";
            }
        }
        if (mimeType != null) {
            builder.setMimeType(mimeType);
        }
        return builder.build();
    }

    @Override
    @NonNull
    public MediaSource.Factory getMediaSourceFactory(@NonNull Context context) {
        return this.getMediaSourceFactory(context, new DefaultHttpDataSource.Factory());
    }

    @VisibleForTesting
    MediaSource.Factory getMediaSourceFactory(Context context, DefaultHttpDataSource.Factory initialFactory) {
        HttpVideoAsset.unstableUpdateDataSourceFactory(initialFactory, this.httpHeaders, this.userAgent);
        DefaultDataSource.Factory dataSourceFactory = new DefaultDataSource.Factory(context, (DataSource.Factory)initialFactory);
        return new DefaultMediaSourceFactory(context).setDataSourceFactory((DataSource.Factory)dataSourceFactory);
    }

    @OptIn(markerClass={UnstableApi.class})
    private static void unstableUpdateDataSourceFactory(@NonNull DefaultHttpDataSource.Factory factory, @NonNull Map<String, String> httpHeaders, @Nullable String userAgent) {
        factory.setUserAgent(userAgent).setAllowCrossProtocolRedirects(true);
        if (!httpHeaders.isEmpty()) {
            factory.setDefaultRequestProperties(httpHeaders);
        }
    }
}

