/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer;

import android.content.Context;
import android.util.LongSparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugins.videoplayer.AndroidVideoPlayerApi;
import io.flutter.plugins.videoplayer.CreationOptions;
import io.flutter.plugins.videoplayer.PlatformVideoFormat;
import io.flutter.plugins.videoplayer.TexturePlayerIds;
import io.flutter.plugins.videoplayer.VideoAsset;
import io.flutter.plugins.videoplayer.VideoPlayer;
import io.flutter.plugins.videoplayer.VideoPlayerEventCallbacks;
import io.flutter.plugins.videoplayer.VideoPlayerInstanceApi;
import io.flutter.plugins.videoplayer.VideoPlayerOptions;
import io.flutter.plugins.videoplayer.platformview.PlatformVideoViewFactory;
import io.flutter.plugins.videoplayer.platformview.PlatformViewVideoPlayer;
import io.flutter.plugins.videoplayer.texture.TextureVideoPlayer;
import io.flutter.view.TextureRegistry;

public class VideoPlayerPlugin
implements FlutterPlugin,
AndroidVideoPlayerApi {
    private static final String TAG = "VideoPlayerPlugin";
    private final LongSparseArray<VideoPlayer> videoPlayers = new LongSparseArray();
    private FlutterState flutterState;
    private final VideoPlayerOptions sharedOptions = new VideoPlayerOptions();
    private long nextPlayerIdentifier = 1L;

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        FlutterInjector injector = FlutterInjector.instance();
        this.flutterState = new FlutterState(binding.getApplicationContext(), binding.getBinaryMessenger(), arg_0 -> ((FlutterLoader)injector.flutterLoader()).getLookupKeyForAsset(arg_0), (arg_0, arg_1) -> ((FlutterLoader)injector.flutterLoader()).getLookupKeyForAsset(arg_0, arg_1), binding.getTextureRegistry());
        this.flutterState.startListening(this, binding.getBinaryMessenger());
        binding.getPlatformViewRegistry().registerViewFactory("plugins.flutter.dev/video_player_android", (PlatformViewFactory)new PlatformVideoViewFactory(arg_0 -> this.videoPlayers.get(arg_0)));
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        if (this.flutterState == null) {
            Log.wtf((String)TAG, (String)"Detached from the engine before registering to it.");
        }
        this.flutterState.stopListening(binding.getBinaryMessenger());
        this.flutterState = null;
        this.onDestroy();
    }

    private void disposeAllPlayers() {
        for (int i = 0; i < this.videoPlayers.size(); ++i) {
            ((VideoPlayer)this.videoPlayers.valueAt(i)).dispose();
        }
        this.videoPlayers.clear();
    }

    public void onDestroy() {
        this.disposeAllPlayers();
    }

    @Override
    public void initialize() {
        this.disposeAllPlayers();
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public long createForPlatformView(@NonNull CreationOptions options) {
        VideoAsset videoAsset = this.videoAssetWithOptions(options);
        long id = this.nextPlayerIdentifier++;
        String streamInstance = Long.toString(id);
        PlatformViewVideoPlayer videoPlayer = PlatformViewVideoPlayer.create(this.flutterState.applicationContext, VideoPlayerEventCallbacks.bindTo(this.flutterState.binaryMessenger, streamInstance), videoAsset, this.sharedOptions);
        this.registerPlayerInstance(videoPlayer, id);
        return id;
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    @NonNull
    public TexturePlayerIds createForTextureView(@NonNull CreationOptions options) {
        VideoAsset videoAsset = this.videoAssetWithOptions(options);
        long id = this.nextPlayerIdentifier++;
        String streamInstance = Long.toString(id);
        TextureRegistry.SurfaceProducer handle = this.flutterState.textureRegistry.createSurfaceProducer();
        TextureVideoPlayer videoPlayer = TextureVideoPlayer.create(this.flutterState.applicationContext, VideoPlayerEventCallbacks.bindTo(this.flutterState.binaryMessenger, streamInstance), handle, videoAsset, this.sharedOptions);
        this.registerPlayerInstance(videoPlayer, id);
        return new TexturePlayerIds(id, handle.id());
    }

    @NonNull
    private VideoAsset videoAssetWithOptions(@NonNull CreationOptions options) {
        String uri = options.getUri();
        if (uri.startsWith("asset:")) {
            return VideoAsset.fromAssetUrl(uri);
        }
        if (uri.startsWith("rtsp:")) {
            return VideoAsset.fromRtspUrl(uri);
        }
        VideoAsset.StreamingFormat streamingFormat = VideoAsset.StreamingFormat.UNKNOWN;
        PlatformVideoFormat formatHint = options.getFormatHint();
        if (formatHint != null) {
            switch (formatHint) {
                case SS: {
                    streamingFormat = VideoAsset.StreamingFormat.SMOOTH;
                    break;
                }
                case DASH: {
                    streamingFormat = VideoAsset.StreamingFormat.DYNAMIC_ADAPTIVE;
                    break;
                }
                case HLS: {
                    streamingFormat = VideoAsset.StreamingFormat.HTTP_LIVE;
                }
            }
        }
        return VideoAsset.fromRemoteUrl(uri, streamingFormat, options.getHttpHeaders(), options.getUserAgent());
    }

    private void registerPlayerInstance(VideoPlayer player, long id) {
        BinaryMessenger messenger = this.flutterState.binaryMessenger;
        String channelSuffix = Long.toString(id);
        VideoPlayerInstanceApi.Companion.setUp(messenger, player, channelSuffix);
        player.setDisposeHandler(() -> VideoPlayerInstanceApi.Companion.setUp(messenger, null, channelSuffix));
        this.videoPlayers.put(id, (Object)player);
    }

    @NonNull
    private VideoPlayer getPlayer(long playerId) {
        VideoPlayer player = (VideoPlayer)this.videoPlayers.get(playerId);
        if (player == null) {
            String message = "No player found with playerId <" + playerId + ">";
            if (this.videoPlayers.size() == 0) {
                message = message + " and no active players created by the plugin.";
            }
            throw new IllegalStateException(message);
        }
        return player;
    }

    @Override
    public void dispose(long playerId) {
        VideoPlayer player = this.getPlayer(playerId);
        player.dispose();
        this.videoPlayers.remove(playerId);
    }

    @Override
    public void setMixWithOthers(boolean mixWithOthers) {
        this.sharedOptions.mixWithOthers = mixWithOthers;
    }

    @Override
    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset, @Nullable String packageName) {
        return packageName == null ? this.flutterState.keyForAsset.get(asset) : this.flutterState.keyForAssetAndPackageName.get(asset, packageName);
    }

    private static final class FlutterState {
        final Context applicationContext;
        final BinaryMessenger binaryMessenger;
        final KeyForAssetFn keyForAsset;
        final KeyForAssetAndPackageName keyForAssetAndPackageName;
        final TextureRegistry textureRegistry;

        FlutterState(Context applicationContext, BinaryMessenger messenger, KeyForAssetFn keyForAsset, KeyForAssetAndPackageName keyForAssetAndPackageName, TextureRegistry textureRegistry) {
            this.applicationContext = applicationContext;
            this.binaryMessenger = messenger;
            this.keyForAsset = keyForAsset;
            this.keyForAssetAndPackageName = keyForAssetAndPackageName;
            this.textureRegistry = textureRegistry;
        }

        void startListening(VideoPlayerPlugin methodCallHandler, BinaryMessenger messenger) {
            AndroidVideoPlayerApi.Companion.setUp(messenger, methodCallHandler);
        }

        void stopListening(BinaryMessenger messenger) {
            AndroidVideoPlayerApi.Companion.setUp(messenger, null);
        }
    }

    private static interface KeyForAssetFn {
        public String get(String var1);
    }

    private static interface KeyForAssetAndPackageName {
        public String get(String var1, String var2);
    }
}

