/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer.platformview;

import android.content.Context;
import android.os.Build;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import io.flutter.plugin.platform.PlatformView;

public final class PlatformVideoView
implements PlatformView {
    @NonNull
    private final SurfaceView surfaceView;

    @OptIn(markerClass={UnstableApi.class})
    public PlatformVideoView(@NonNull Context context, @NonNull ExoPlayer exoPlayer) {
        this.surfaceView = new SurfaceView(context);
        if (Build.VERSION.SDK_INT == 28) {
            this.setupSurfaceWithCallback(exoPlayer);
        } else {
            if (Build.VERSION.SDK_INT <= 25) {
                this.surfaceView.setZOrderMediaOverlay(true);
            }
            exoPlayer.setVideoSurfaceView(this.surfaceView);
        }
    }

    private void setupSurfaceWithCallback(final @NonNull ExoPlayer exoPlayer) {
        this.surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(@NonNull SurfaceHolder holder) {
                exoPlayer.setVideoSurface(holder.getSurface());
                exoPlayer.seekTo(1L);
            }

            public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
                exoPlayer.setVideoSurface(null);
            }
        });
    }

    @NonNull
    public View getView() {
        return this.surfaceView;
    }

    public void dispose() {
        this.surfaceView.getHolder().getSurface().release();
    }
}

