/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer.platformview;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import io.flutter.plugins.videoplayer.ExoPlayerEventListener;
import io.flutter.plugins.videoplayer.VideoPlayerCallbacks;
import java.util.Objects;

public final class PlatformViewExoPlayerEventListener
extends ExoPlayerEventListener {
    public PlatformViewExoPlayerEventListener(@NonNull ExoPlayer exoPlayer, @NonNull VideoPlayerCallbacks events) {
        super(exoPlayer, events);
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    protected void sendInitialized() {
        Format videoFormat = this.exoPlayer.getVideoFormat();
        ExoPlayerEventListener.RotationDegrees rotationCorrection = ExoPlayerEventListener.RotationDegrees.fromDegrees(Objects.requireNonNull(videoFormat).rotationDegrees);
        int width = videoFormat.width;
        int height = videoFormat.height;
        if (rotationCorrection == ExoPlayerEventListener.RotationDegrees.ROTATE_90 || rotationCorrection == ExoPlayerEventListener.RotationDegrees.ROTATE_270) {
            width = videoFormat.height;
            height = videoFormat.width;
            rotationCorrection = ExoPlayerEventListener.RotationDegrees.fromDegrees(0);
        }
        this.events.onInitialized(width, height, this.exoPlayer.getDuration(), rotationCorrection.getDegrees());
    }
}

