/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer.platformview;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import io.flutter.plugins.videoplayer.ExoPlayerEventListener;
import io.flutter.plugins.videoplayer.VideoAsset;
import io.flutter.plugins.videoplayer.VideoPlayer;
import io.flutter.plugins.videoplayer.VideoPlayerCallbacks;
import io.flutter.plugins.videoplayer.VideoPlayerOptions;
import io.flutter.plugins.videoplayer.platformview.PlatformViewExoPlayerEventListener;
import io.flutter.view.TextureRegistry;

public class PlatformViewVideoPlayer
extends VideoPlayer {
    @UnstableApi
    @VisibleForTesting
    public PlatformViewVideoPlayer(@NonNull VideoPlayerCallbacks events, @NonNull MediaItem mediaItem, @NonNull VideoPlayerOptions options, @NonNull VideoPlayer.ExoPlayerProvider exoPlayerProvider) {
        super(events, mediaItem, options, null, exoPlayerProvider);
    }

    @UnstableApi
    @NonNull
    public static PlatformViewVideoPlayer create(@NonNull Context context, @NonNull VideoPlayerCallbacks events, @NonNull VideoAsset asset, @NonNull VideoPlayerOptions options) {
        return new PlatformViewVideoPlayer(events, asset.getMediaItem(), options, () -> {
            DefaultTrackSelector trackSelector = new DefaultTrackSelector(context);
            ExoPlayer.Builder builder = new ExoPlayer.Builder(context).setTrackSelector((TrackSelector)trackSelector).setMediaSourceFactory(asset.getMediaSourceFactory(context));
            return builder.build();
        });
    }

    @Override
    @NonNull
    protected ExoPlayerEventListener createExoPlayerEventListener(@NonNull ExoPlayer exoPlayer, @Nullable TextureRegistry.SurfaceProducer surfaceProducer) {
        return new PlatformViewExoPlayerEventListener(exoPlayer, this.videoPlayerEvents);
    }
}

