/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.videoplayer.AudioTrackChangedEvent;
import io.flutter.plugins.videoplayer.InitializationEvent;
import io.flutter.plugins.videoplayer.IsPlayingStateEvent;
import io.flutter.plugins.videoplayer.PigeonEventSink;
import io.flutter.plugins.videoplayer.PlatformPlaybackState;
import io.flutter.plugins.videoplayer.PlatformVideoEvent;
import io.flutter.plugins.videoplayer.PlaybackStateChangeEvent;
import io.flutter.plugins.videoplayer.QueuingEventSink;
import io.flutter.plugins.videoplayer.VideoEventsStreamHandler;
import io.flutter.plugins.videoplayer.VideoPlayerCallbacks;

final class VideoPlayerEventCallbacks
implements VideoPlayerCallbacks {
    private final QueuingEventSink eventSink;

    static VideoPlayerEventCallbacks bindTo(@NonNull BinaryMessenger binaryMessenger, @NonNull String identifier) {
        final QueuingEventSink eventSink = new QueuingEventSink();
        VideoEventsStreamHandler.Companion.register(binaryMessenger, new VideoEventsStreamHandler(){

            @Override
            public void onListen(Object arguments, @NonNull PigeonEventSink<PlatformVideoEvent> events) {
                eventSink.setDelegate(events);
            }

            @Override
            public void onCancel(Object arguments) {
                eventSink.setDelegate(null);
            }
        }, identifier);
        return VideoPlayerEventCallbacks.withSink(eventSink);
    }

    @VisibleForTesting
    static VideoPlayerEventCallbacks withSink(QueuingEventSink eventSink) {
        return new VideoPlayerEventCallbacks(eventSink);
    }

    private VideoPlayerEventCallbacks(QueuingEventSink eventSink) {
        this.eventSink = eventSink;
    }

    @Override
    public void onInitialized(int width, int height, long durationInMs, int rotationCorrectionInDegrees) {
        this.eventSink.success(new InitializationEvent(durationInMs, width, height, rotationCorrectionInDegrees));
    }

    @Override
    public void onPlaybackStateChanged(@NonNull PlatformPlaybackState state) {
        this.eventSink.success(new PlaybackStateChangeEvent(state));
    }

    @Override
    public void onError(@NonNull String code, @Nullable String message, @Nullable Object details) {
        this.eventSink.error(code, message, details);
    }

    @Override
    public void onIsPlayingStateUpdate(boolean isPlaying) {
        this.eventSink.success(new IsPlayingStateEvent(isPlaying));
    }

    @Override
    public void onAudioTrackChanged(@Nullable String selectedTrackId) {
        this.eventSink.success(new AudioTrackChangedEvent(selectedTrackId));
    }
}

