/*
 * Decompiled with CFR 0.152.
 */
package xyz.justsoft.video_thumbnail;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VideoThumbnailPlugin
implements FlutterPlugin,
MethodChannel.MethodCallHandler {
    private static String TAG = "ThumbnailPlugin";
    private static final int HIGH_QUALITY_MIN_VAL = 70;
    private Context context;
    private ExecutorService executor;
    private MethodChannel channel;

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.context = binding.getApplicationContext();
        this.executor = Executors.newCachedThreadPool();
        this.channel = new MethodChannel(binding.getBinaryMessenger(), "plugins.justsoft.xyz/video_thumbnail");
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel.setMethodCallHandler(null);
        this.channel = null;
        this.executor.shutdown();
        this.executor = null;
    }

    public void onMethodCall(@NonNull MethodCall call, final @NonNull MethodChannel.Result result) {
        final Map args = (Map)call.arguments();
        final String video = (String)args.get("video");
        final HashMap headers = (HashMap)args.get("headers");
        final int format = (Integer)args.get("format");
        final int maxh = (Integer)args.get("maxh");
        final int maxw = (Integer)args.get("maxw");
        final int timeMs = (Integer)args.get("timeMs");
        final int quality = (Integer)args.get("quality");
        final String method = call.method;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Object thumbnail = null;
                boolean handled = false;
                Exception exc = null;
                try {
                    if (method.equals("file")) {
                        String path = (String)args.get("path");
                        thumbnail = VideoThumbnailPlugin.this.buildThumbnailFile(video, headers, path, format, maxh, maxw, timeMs, quality);
                        handled = true;
                    } else if (method.equals("data")) {
                        thumbnail = VideoThumbnailPlugin.this.buildThumbnailData(video, headers, format, maxh, maxw, timeMs, quality);
                        handled = true;
                    }
                }
                catch (Exception e) {
                    exc = e;
                }
                VideoThumbnailPlugin.this.onResult(result, thumbnail, handled, exc);
            }
        });
    }

    private static Bitmap.CompressFormat intToFormat(int format) {
        switch (format) {
            default: {
                return Bitmap.CompressFormat.JPEG;
            }
            case 1: {
                return Bitmap.CompressFormat.PNG;
            }
            case 2: 
        }
        return Bitmap.CompressFormat.WEBP;
    }

    private static String formatExt(int format) {
        switch (format) {
            default: {
                return "jpg";
            }
            case 1: {
                return "png";
            }
            case 2: 
        }
        return "webp";
    }

    private byte[] buildThumbnailData(String vidPath, HashMap<String, String> headers, int format, int maxh, int maxw, int timeMs, int quality) {
        Bitmap bitmap = this.createVideoThumbnail(vidPath, headers, maxh, maxw, timeMs);
        if (bitmap == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(VideoThumbnailPlugin.intToFormat(format), quality, (OutputStream)stream);
        bitmap.recycle();
        if (bitmap == null) {
            throw new NullPointerException();
        }
        return stream.toByteArray();
    }

    private String buildThumbnailFile(String vidPath, HashMap<String, String> headers, String path, int format, int maxh, int maxw, int timeMs, int quality) {
        boolean isLocalFile;
        byte[] bytes = this.buildThumbnailData(vidPath, headers, format, maxh, maxw, timeMs, quality);
        String ext = VideoThumbnailPlugin.formatExt(format);
        int i = vidPath.lastIndexOf(".");
        String fullpath = vidPath.substring(0, i + 1) + ext;
        boolean bl = isLocalFile = vidPath.startsWith("/") || vidPath.startsWith("file://");
        if (path == null && !isLocalFile) {
            path = this.context.getCacheDir().getAbsolutePath();
        }
        if (path != null) {
            if (path.endsWith(ext)) {
                fullpath = path;
            } else {
                int j = fullpath.lastIndexOf("/");
                fullpath = path.endsWith("/") ? path + fullpath.substring(j + 1) : path + fullpath.substring(j);
            }
        }
        try {
            FileOutputStream f = new FileOutputStream(fullpath);
            f.write(bytes);
            f.close();
            Log.d((String)TAG, (String)String.format("buildThumbnailFile( written:%d )", bytes.length));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return fullpath;
    }

    private void onResult(final MethodChannel.Result result, final Object thumbnail, final boolean handled, final Exception e) {
        VideoThumbnailPlugin.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!handled) {
                    result.notImplemented();
                    return;
                }
                if (e != null) {
                    e.printStackTrace();
                    result.error("exception", e.getMessage(), null);
                    return;
                }
                result.success(thumbnail);
            }
        });
    }

    private static void runOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap createVideoThumbnail(String video, HashMap<String, String> headers, int targetH, int targetW, int timeMs) {
        Bitmap bitmap = null;
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            if (video.startsWith("/")) {
                VideoThumbnailPlugin.setDataSource(video, retriever);
            } else if (video.startsWith("file://")) {
                VideoThumbnailPlugin.setDataSource(video.substring(7), retriever);
            } else {
                retriever.setDataSource(video, (Map)(headers != null ? headers : new HashMap()));
            }
            if (targetH != 0 || targetW != 0) {
                if (Build.VERSION.SDK_INT >= 27 && targetH != 0 && targetW != 0) {
                    bitmap = retriever.getScaledFrameAtTime((long)(timeMs * 1000), 3, targetW, targetH);
                } else {
                    bitmap = retriever.getFrameAtTime((long)(timeMs * 1000), 3);
                    if (bitmap != null) {
                        int width = bitmap.getWidth();
                        int height = bitmap.getHeight();
                        if (targetW == 0) {
                            targetW = Math.round((float)targetH / (float)height * (float)width);
                        }
                        if (targetH == 0) {
                            targetH = Math.round((float)targetW / (float)width * (float)height);
                        }
                        Log.d((String)TAG, (String)String.format("original w:%d, h:%d => %d, %d", width, height, targetW, targetH));
                        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)targetW, (int)targetH, (boolean)true);
                    }
                }
            } else {
                bitmap = retriever.getFrameAtTime((long)(timeMs * 1000), 3);
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                retriever.release();
            }
            catch (IOException | RuntimeException ex) {
                ex.printStackTrace();
            }
        }
        return bitmap;
    }

    private static void setDataSource(String video, MediaMetadataRetriever retriever) throws IOException {
        File videoFile = new File(video);
        FileInputStream inputStream = new FileInputStream(videoFile.getAbsolutePath());
        retriever.setDataSource(inputStream.getFD());
    }
}

