/*
 * Decompiled with CFR 0.152.
 */
package dev.fluttercommunity.plus.device_info;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u0016"}, d2={"Ldev/fluttercommunity/plus/device_info/MethodCallHandlerImpl;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "packageManager", "Landroid/content/pm/PackageManager;", "activityManager", "Landroid/app/ActivityManager;", "contentResolver", "Landroid/content/ContentResolver;", "<init>", "(Landroid/content/pm/PackageManager;Landroid/app/ActivityManager;Landroid/content/ContentResolver;)V", "onMethodCall", "", "call", "Lio/flutter/plugin/common/MethodCall;", "result", "Lio/flutter/plugin/common/MethodChannel$Result;", "getSystemFeatures", "", "", "isEmulator", "", "()Z", "device_info_plus_release"})
@SourceDebugExtension(value={"SMAP\nMethodCallHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodCallHandlerImpl.kt\ndev/fluttercommunity/plus/device_info/MethodCallHandlerImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n4154#2:116\n4254#2,2:117\n1563#3:119\n1634#3,3:120\n*S KotlinDebug\n*F\n+ 1 MethodCallHandlerImpl.kt\ndev/fluttercommunity/plus/device_info/MethodCallHandlerImpl\n*L\n92#1:116\n92#1:117,2\n93#1:119\n93#1:120,3\n*E\n"})
public final class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    @NotNull
    private final PackageManager packageManager;
    @NotNull
    private final ActivityManager activityManager;
    @NotNull
    private final ContentResolver contentResolver;

    public MethodCallHandlerImpl(@NotNull PackageManager packageManager, @NotNull ActivityManager activityManager, @NotNull ContentResolver contentResolver) {
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        Intrinsics.checkNotNullParameter((Object)activityManager, (String)"activityManager");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        this.packageManager = packageManager;
        this.activityManager = activityManager;
        this.contentResolver = contentResolver;
    }

    public void onMethodCall(@NotNull MethodCall call, @NotNull MethodChannel.Result result) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (call.method.equals("getDeviceInfo")) {
            Object object;
            String string;
            Map map;
            Map build = new HashMap();
            build.put("board", Build.BOARD);
            build.put("bootloader", Build.BOOTLOADER);
            build.put("brand", Build.BRAND);
            build.put("device", Build.DEVICE);
            build.put("display", Build.DISPLAY);
            build.put("fingerprint", Build.FINGERPRINT);
            build.put("hardware", Build.HARDWARE);
            build.put("host", Build.HOST);
            build.put("id", Build.ID);
            build.put("manufacturer", Build.MANUFACTURER);
            build.put("model", Build.MODEL);
            build.put("product", Build.PRODUCT);
            if (Build.VERSION.SDK_INT >= 25) {
                map = build;
                string = "name";
                String string2 = Settings.Global.getString((ContentResolver)this.contentResolver, (String)"device_name");
                if (string2 == null) {
                    string2 = "";
                }
                object = string2;
                map.put(string, object);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                map = build;
                string = "supported32BitAbis";
                object = Build.SUPPORTED_32_BIT_ABIS;
                object = CollectionsKt.listOf((Object[])Arrays.copyOf(object, ((String[])object).length));
                map.put(string, object);
                map = build;
                string = "supported64BitAbis";
                object = Build.SUPPORTED_64_BIT_ABIS;
                object = CollectionsKt.listOf((Object[])Arrays.copyOf(object, ((String[])object).length));
                map.put(string, object);
                map = build;
                string = "supportedAbis";
                object = Build.SUPPORTED_ABIS;
                object = CollectionsKt.listOf((Object[])Arrays.copyOf(object, ((String[])object).length));
                map.put(string, object);
            } else {
                build.put("supported32BitAbis", CollectionsKt.emptyList());
                build.put("supported64BitAbis", CollectionsKt.emptyList());
                build.put("supportedAbis", CollectionsKt.emptyList());
            }
            build.put("tags", Build.TAGS);
            build.put("type", Build.TYPE);
            build.put("isPhysicalDevice", !this.isEmulator());
            build.put("systemFeatures", this.getSystemFeatures());
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            build.put("freeDiskSize", statFs.getFreeBytes());
            build.put("totalDiskSize", statFs.getTotalBytes());
            Map version = new HashMap();
            if (Build.VERSION.SDK_INT >= 23) {
                version.put("baseOS", Build.VERSION.BASE_OS);
                version.put("previewSdkInt", Build.VERSION.PREVIEW_SDK_INT);
                version.put("securityPatch", Build.VERSION.SECURITY_PATCH);
            }
            version.put("codename", Build.VERSION.CODENAME);
            version.put("incremental", Build.VERSION.INCREMENTAL);
            version.put("release", Build.VERSION.RELEASE);
            version.put("sdkInt", Build.VERSION.SDK_INT);
            build.put("version", version);
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            this.activityManager.getMemoryInfo(memoryInfo);
            build.put("isLowRamDevice", memoryInfo.lowMemory);
            build.put("physicalRamSize", memoryInfo.totalMem / 0x100000L);
            build.put("availableRamSize", memoryInfo.availMem / 0x100000L);
            result.success((Object)build);
        } else {
            result.notImplemented();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getSystemFeatures() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        FeatureInfo[] featureInfos;
        FeatureInfo[] featureInfoArray = this.packageManager.getSystemAvailableFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)featureInfoArray, (String)"getSystemAvailableFeatures(...)");
        FeatureInfo[] $this$filterNot$iv = featureInfos = featureInfoArray;
        boolean $i$f$filterNot = false;
        FeatureInfo[] featureInfoArray2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (FeatureInfo element$iv$iv : $this$filterNotTo$iv$iv) {
            void featureInfo = element$iv$iv;
            boolean bl = false;
            if (featureInfo.name == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void featureInfo;
            FeatureInfo element$iv$iv;
            element$iv$iv = (FeatureInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(featureInfo.name);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEmulator() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) {
            String string2 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEVICE");
            if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        String string3 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string3, (String)"generic", (boolean)false, (int)2, null)) return true;
        String string4 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string4, (String)"unknown", (boolean)false, (int)2, null)) return true;
        String string5 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"goldfish", (boolean)false, (int)2, null)) return true;
        String string6 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"ranchu", (boolean)false, (int)2, null)) return true;
        String string7 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string8 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        String string9 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        String string10 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        String string11 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string11, (CharSequence)"sdk", (boolean)false, (int)2, null)) return true;
        String string12 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string12, (CharSequence)"vbox86p", (boolean)false, (int)2, null)) return true;
        String string13 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string13, (CharSequence)"emulator", (boolean)false, (int)2, null)) return true;
        String string14 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"PRODUCT");
        if (!StringsKt.contains$default((CharSequence)string14, (CharSequence)"simulator", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

