/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.core;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePluginRegistry;
import io.flutter.plugins.firebase.core.GeneratedAndroidFirebaseCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlutterFirebaseCorePlugin
implements FlutterPlugin,
GeneratedAndroidFirebaseCore.FirebaseCoreHostApi,
GeneratedAndroidFirebaseCore.FirebaseAppHostApi {
    private Context applicationContext;
    private boolean coreInitialized = false;
    public static Map<String, String> customAuthDomain = new HashMap<String, String>();

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        GeneratedAndroidFirebaseCore.FirebaseCoreHostApi.setUp(binding.getBinaryMessenger(), this);
        GeneratedAndroidFirebaseCore.FirebaseAppHostApi.setUp(binding.getBinaryMessenger(), this);
        this.applicationContext = binding.getApplicationContext();
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.applicationContext = null;
        GeneratedAndroidFirebaseCore.FirebaseCoreHostApi.setUp(binding.getBinaryMessenger(), null);
        GeneratedAndroidFirebaseCore.FirebaseAppHostApi.setUp(binding.getBinaryMessenger(), null);
    }

    private GeneratedAndroidFirebaseCore.CoreFirebaseOptions firebaseOptionsToMap(FirebaseOptions options) {
        GeneratedAndroidFirebaseCore.CoreFirebaseOptions.Builder firebaseOptions = new GeneratedAndroidFirebaseCore.CoreFirebaseOptions.Builder();
        firebaseOptions.setApiKey(options.getApiKey());
        firebaseOptions.setAppId(options.getApplicationId());
        if (options.getGcmSenderId() != null) {
            firebaseOptions.setMessagingSenderId(options.getGcmSenderId());
        }
        if (options.getProjectId() != null) {
            firebaseOptions.setProjectId(options.getProjectId());
        }
        firebaseOptions.setDatabaseURL(options.getDatabaseUrl());
        firebaseOptions.setStorageBucket(options.getStorageBucket());
        firebaseOptions.setTrackingId(options.getGaTrackingId());
        return firebaseOptions.build();
    }

    private Task<GeneratedAndroidFirebaseCore.CoreInitializeResponse> firebaseAppToMap(FirebaseApp firebaseApp) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                GeneratedAndroidFirebaseCore.CoreInitializeResponse.Builder initializeResponse = new GeneratedAndroidFirebaseCore.CoreInitializeResponse.Builder();
                initializeResponse.setName(firebaseApp.getName());
                initializeResponse.setOptions(this.firebaseOptionsToMap(firebaseApp.getOptions()));
                initializeResponse.setIsAutomaticDataCollectionEnabled(firebaseApp.isDataCollectionDefaultEnabled());
                initializeResponse.setPluginConstants((Map)Tasks.await(FlutterFirebasePluginRegistry.getPluginConstantsForFirebaseApp(firebaseApp)));
                taskCompletionSource.setResult((Object)initializeResponse.build());
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private <T> void listenToResponse(TaskCompletionSource<T> taskCompletionSource, GeneratedAndroidFirebaseCore.Result<T> result) {
        taskCompletionSource.getTask().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success(task.getResult());
            } else {
                Exception exception = task.getException();
                result.error(exception);
            }
        });
    }

    private void listenToVoidResponse(TaskCompletionSource<Void> taskCompletionSource, GeneratedAndroidFirebaseCore.VoidResult result) {
        taskCompletionSource.getTask().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                Exception exception = task.getException();
                result.error(exception);
            }
        });
    }

    @Override
    public void initializeApp(@NonNull String appName, @NonNull GeneratedAndroidFirebaseCore.CoreFirebaseOptions initializeAppRequest, GeneratedAndroidFirebaseCore.Result<GeneratedAndroidFirebaseCore.CoreInitializeResponse> result) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                FirebaseOptions options = new FirebaseOptions.Builder().setApiKey(initializeAppRequest.getApiKey()).setApplicationId(initializeAppRequest.getAppId()).setDatabaseUrl(initializeAppRequest.getDatabaseURL()).setGcmSenderId(initializeAppRequest.getMessagingSenderId()).setProjectId(initializeAppRequest.getProjectId()).setStorageBucket(initializeAppRequest.getStorageBucket()).setGaTrackingId(initializeAppRequest.getTrackingId()).build();
                try {
                    Looper.prepare();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (initializeAppRequest.getAuthDomain() != null) {
                    customAuthDomain.put(appName, initializeAppRequest.getAuthDomain());
                }
                FirebaseApp firebaseApp = FirebaseApp.initializeApp((Context)this.applicationContext, (FirebaseOptions)options, (String)appName);
                taskCompletionSource.setResult((Object)((GeneratedAndroidFirebaseCore.CoreInitializeResponse)Tasks.await(this.firebaseAppToMap(firebaseApp))));
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        this.listenToResponse(taskCompletionSource, result);
    }

    @Override
    public void initializeCore(GeneratedAndroidFirebaseCore.Result<List<GeneratedAndroidFirebaseCore.CoreInitializeResponse>> result) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                if (!this.coreInitialized) {
                    this.coreInitialized = true;
                } else {
                    Tasks.await(FlutterFirebasePluginRegistry.didReinitializeFirebaseCore());
                }
                List firebaseApps = FirebaseApp.getApps((Context)this.applicationContext);
                ArrayList<GeneratedAndroidFirebaseCore.CoreInitializeResponse> firebaseAppsList = new ArrayList<GeneratedAndroidFirebaseCore.CoreInitializeResponse>(firebaseApps.size());
                for (FirebaseApp firebaseApp : firebaseApps) {
                    firebaseAppsList.add((GeneratedAndroidFirebaseCore.CoreInitializeResponse)Tasks.await(this.firebaseAppToMap(firebaseApp)));
                }
                taskCompletionSource.setResult(firebaseAppsList);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        this.listenToResponse(taskCompletionSource, result);
    }

    @Override
    public void optionsFromResource(GeneratedAndroidFirebaseCore.Result<GeneratedAndroidFirebaseCore.CoreFirebaseOptions> result) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                FirebaseOptions options = FirebaseOptions.fromResource((Context)this.applicationContext);
                if (options == null) {
                    taskCompletionSource.setException(new Exception("Failed to load FirebaseOptions from resource. Check that you have defined values.xml correctly."));
                    return;
                }
                taskCompletionSource.setResult((Object)this.firebaseOptionsToMap(options));
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        this.listenToResponse(taskCompletionSource, result);
    }

    @Override
    public void setAutomaticDataCollectionEnabled(@NonNull String appName, @NonNull Boolean enabled, GeneratedAndroidFirebaseCore.VoidResult result) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                FirebaseApp firebaseApp = FirebaseApp.getInstance((String)appName);
                firebaseApp.setDataCollectionDefaultEnabled(enabled);
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        this.listenToVoidResponse((TaskCompletionSource<Void>)taskCompletionSource, result);
    }

    @Override
    public void setAutomaticResourceManagementEnabled(@NonNull String appName, @NonNull Boolean enabled, GeneratedAndroidFirebaseCore.VoidResult result) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                FirebaseApp firebaseApp = FirebaseApp.getInstance((String)appName);
                firebaseApp.setAutomaticResourceManagementEnabled(enabled.booleanValue());
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        this.listenToVoidResponse((TaskCompletionSource<Void>)taskCompletionSource, result);
    }

    @Override
    public void delete(@NonNull String appName, GeneratedAndroidFirebaseCore.VoidResult result) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FlutterFirebasePlugin.cachedThreadPool.execute(() -> {
            try {
                FirebaseApp firebaseApp = FirebaseApp.getInstance((String)appName);
                try {
                    firebaseApp.delete();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        this.listenToVoidResponse((TaskCompletionSource<Void>)taskCompletionSource, result);
    }
}

