/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.core;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GeneratedAndroidFirebaseCore {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface FirebaseAppHostApi {
        public void setAutomaticDataCollectionEnabled(@NonNull String var1, @NonNull Boolean var2, @NonNull VoidResult var3);

        public void setAutomaticResourceManagementEnabled(@NonNull String var1, @NonNull Boolean var2, @NonNull VoidResult var3);

        public void delete(@NonNull String var1, @NonNull VoidResult var2);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseAppHostApi api) {
            FirebaseAppHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable FirebaseAppHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_core_platform_interface.FirebaseAppHostApi.setAutomaticDataCollectionEnabled" + messageChannelSuffix, FirebaseAppHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    Boolean enabledArg = (Boolean)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setAutomaticDataCollectionEnabled(appNameArg, enabledArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_core_platform_interface.FirebaseAppHostApi.setAutomaticResourceManagementEnabled" + messageChannelSuffix, FirebaseAppHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    Boolean enabledArg = (Boolean)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setAutomaticResourceManagementEnabled(appNameArg, enabledArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_core_platform_interface.FirebaseAppHostApi.delete" + messageChannelSuffix, FirebaseAppHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.delete(appNameArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface FirebaseCoreHostApi {
        public void initializeApp(@NonNull String var1, @NonNull CoreFirebaseOptions var2, @NonNull Result<CoreInitializeResponse> var3);

        public void initializeCore(@NonNull Result<List<CoreInitializeResponse>> var1);

        public void optionsFromResource(@NonNull Result<CoreFirebaseOptions> var1);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseCoreHostApi api) {
            FirebaseCoreHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable FirebaseCoreHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_core_platform_interface.FirebaseCoreHostApi.initializeApp" + messageChannelSuffix, FirebaseCoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String appNameArg = (String)args.get(0);
                    CoreFirebaseOptions initializeAppRequestArg = (CoreFirebaseOptions)args.get(1);
                    Result<CoreInitializeResponse> resultCallback = new Result<CoreInitializeResponse>(){

                        @Override
                        public void success(CoreInitializeResponse result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.initializeApp(appNameArg, initializeAppRequestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_core_platform_interface.FirebaseCoreHostApi.initializeCore" + messageChannelSuffix, FirebaseCoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    Result<List<CoreInitializeResponse>> resultCallback = new Result<List<CoreInitializeResponse>>(){

                        @Override
                        public void success(List<CoreInitializeResponse> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.initializeCore(resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_core_platform_interface.FirebaseCoreHostApi.optionsFromResource" + messageChannelSuffix, FirebaseCoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    Result<CoreFirebaseOptions> resultCallback = new Result<CoreFirebaseOptions>(){

                        @Override
                        public void success(CoreFirebaseOptions result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseCore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.optionsFromResource(resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface VoidResult {
        public void success();

        public void error(@NonNull Throwable var1);
    }

    public static interface NullableResult<T> {
        public void success(@Nullable T var1);

        public void error(@NonNull Throwable var1);
    }

    public static interface Result<T> {
        public void success(@NonNull T var1);

        public void error(@NonNull Throwable var1);
    }

    private static class PigeonCodec
    extends StandardMessageCodec {
        public static final PigeonCodec INSTANCE = new PigeonCodec();

        private PigeonCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -127: {
                    return CoreFirebaseOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return CoreInitializeResponse.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof CoreFirebaseOptions) {
                stream.write(129);
                this.writeValue(stream, ((CoreFirebaseOptions)value).toList());
            } else if (value instanceof CoreInitializeResponse) {
                stream.write(130);
                this.writeValue(stream, ((CoreInitializeResponse)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static final class CoreInitializeResponse {
        @NonNull
        private String name;
        @NonNull
        private CoreFirebaseOptions options;
        @Nullable
        private Boolean isAutomaticDataCollectionEnabled;
        @NonNull
        private Map<String, Object> pluginConstants;

        @NonNull
        public String getName() {
            return this.name;
        }

        public void setName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"name\" is null.");
            }
            this.name = setterArg;
        }

        @NonNull
        public CoreFirebaseOptions getOptions() {
            return this.options;
        }

        public void setOptions(@NonNull CoreFirebaseOptions setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"options\" is null.");
            }
            this.options = setterArg;
        }

        @Nullable
        public Boolean getIsAutomaticDataCollectionEnabled() {
            return this.isAutomaticDataCollectionEnabled;
        }

        public void setIsAutomaticDataCollectionEnabled(@Nullable Boolean setterArg) {
            this.isAutomaticDataCollectionEnabled = setterArg;
        }

        @NonNull
        public Map<String, Object> getPluginConstants() {
            return this.pluginConstants;
        }

        public void setPluginConstants(@NonNull Map<String, Object> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"pluginConstants\" is null.");
            }
            this.pluginConstants = setterArg;
        }

        CoreInitializeResponse() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoreInitializeResponse that = (CoreInitializeResponse)o;
            return this.name.equals(that.name) && this.options.equals(that.options) && Objects.equals(this.isAutomaticDataCollectionEnabled, that.isAutomaticDataCollectionEnabled) && this.pluginConstants.equals(that.pluginConstants);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.options, this.isAutomaticDataCollectionEnabled, this.pluginConstants);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.name);
            toListResult.add(this.options);
            toListResult.add(this.isAutomaticDataCollectionEnabled);
            toListResult.add(this.pluginConstants);
            return toListResult;
        }

        @NonNull
        static CoreInitializeResponse fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            CoreInitializeResponse pigeonResult = new CoreInitializeResponse();
            Object name = pigeonVar_list.get(0);
            pigeonResult.setName((String)name);
            Object options = pigeonVar_list.get(1);
            pigeonResult.setOptions((CoreFirebaseOptions)options);
            Object isAutomaticDataCollectionEnabled = pigeonVar_list.get(2);
            pigeonResult.setIsAutomaticDataCollectionEnabled((Boolean)isAutomaticDataCollectionEnabled);
            Object pluginConstants = pigeonVar_list.get(3);
            pigeonResult.setPluginConstants((Map)pluginConstants);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private CoreFirebaseOptions options;
            @Nullable
            private Boolean isAutomaticDataCollectionEnabled;
            @Nullable
            private Map<String, Object> pluginConstants;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setName(@NonNull String setterArg) {
                this.name = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setOptions(@NonNull CoreFirebaseOptions setterArg) {
                this.options = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIsAutomaticDataCollectionEnabled(@Nullable Boolean setterArg) {
                this.isAutomaticDataCollectionEnabled = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPluginConstants(@NonNull Map<String, Object> setterArg) {
                this.pluginConstants = setterArg;
                return this;
            }

            @NonNull
            public CoreInitializeResponse build() {
                CoreInitializeResponse pigeonReturn = new CoreInitializeResponse();
                pigeonReturn.setName(this.name);
                pigeonReturn.setOptions(this.options);
                pigeonReturn.setIsAutomaticDataCollectionEnabled(this.isAutomaticDataCollectionEnabled);
                pigeonReturn.setPluginConstants(this.pluginConstants);
                return pigeonReturn;
            }
        }
    }

    public static final class CoreFirebaseOptions {
        @NonNull
        private String apiKey;
        @NonNull
        private String appId;
        @NonNull
        private String messagingSenderId;
        @NonNull
        private String projectId;
        @Nullable
        private String authDomain;
        @Nullable
        private String databaseURL;
        @Nullable
        private String storageBucket;
        @Nullable
        private String measurementId;
        @Nullable
        private String trackingId;
        @Nullable
        private String deepLinkURLScheme;
        @Nullable
        private String androidClientId;
        @Nullable
        private String iosClientId;
        @Nullable
        private String iosBundleId;
        @Nullable
        private String appGroupId;

        @NonNull
        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"apiKey\" is null.");
            }
            this.apiKey = setterArg;
        }

        @NonNull
        public String getAppId() {
            return this.appId;
        }

        public void setAppId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"appId\" is null.");
            }
            this.appId = setterArg;
        }

        @NonNull
        public String getMessagingSenderId() {
            return this.messagingSenderId;
        }

        public void setMessagingSenderId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"messagingSenderId\" is null.");
            }
            this.messagingSenderId = setterArg;
        }

        @NonNull
        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"projectId\" is null.");
            }
            this.projectId = setterArg;
        }

        @Nullable
        public String getAuthDomain() {
            return this.authDomain;
        }

        public void setAuthDomain(@Nullable String setterArg) {
            this.authDomain = setterArg;
        }

        @Nullable
        public String getDatabaseURL() {
            return this.databaseURL;
        }

        public void setDatabaseURL(@Nullable String setterArg) {
            this.databaseURL = setterArg;
        }

        @Nullable
        public String getStorageBucket() {
            return this.storageBucket;
        }

        public void setStorageBucket(@Nullable String setterArg) {
            this.storageBucket = setterArg;
        }

        @Nullable
        public String getMeasurementId() {
            return this.measurementId;
        }

        public void setMeasurementId(@Nullable String setterArg) {
            this.measurementId = setterArg;
        }

        @Nullable
        public String getTrackingId() {
            return this.trackingId;
        }

        public void setTrackingId(@Nullable String setterArg) {
            this.trackingId = setterArg;
        }

        @Nullable
        public String getDeepLinkURLScheme() {
            return this.deepLinkURLScheme;
        }

        public void setDeepLinkURLScheme(@Nullable String setterArg) {
            this.deepLinkURLScheme = setterArg;
        }

        @Nullable
        public String getAndroidClientId() {
            return this.androidClientId;
        }

        public void setAndroidClientId(@Nullable String setterArg) {
            this.androidClientId = setterArg;
        }

        @Nullable
        public String getIosClientId() {
            return this.iosClientId;
        }

        public void setIosClientId(@Nullable String setterArg) {
            this.iosClientId = setterArg;
        }

        @Nullable
        public String getIosBundleId() {
            return this.iosBundleId;
        }

        public void setIosBundleId(@Nullable String setterArg) {
            this.iosBundleId = setterArg;
        }

        @Nullable
        public String getAppGroupId() {
            return this.appGroupId;
        }

        public void setAppGroupId(@Nullable String setterArg) {
            this.appGroupId = setterArg;
        }

        CoreFirebaseOptions() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoreFirebaseOptions that = (CoreFirebaseOptions)o;
            return this.apiKey.equals(that.apiKey) && this.appId.equals(that.appId) && this.messagingSenderId.equals(that.messagingSenderId) && this.projectId.equals(that.projectId) && Objects.equals(this.authDomain, that.authDomain) && Objects.equals(this.databaseURL, that.databaseURL) && Objects.equals(this.storageBucket, that.storageBucket) && Objects.equals(this.measurementId, that.measurementId) && Objects.equals(this.trackingId, that.trackingId) && Objects.equals(this.deepLinkURLScheme, that.deepLinkURLScheme) && Objects.equals(this.androidClientId, that.androidClientId) && Objects.equals(this.iosClientId, that.iosClientId) && Objects.equals(this.iosBundleId, that.iosBundleId) && Objects.equals(this.appGroupId, that.appGroupId);
        }

        public int hashCode() {
            return Objects.hash(this.apiKey, this.appId, this.messagingSenderId, this.projectId, this.authDomain, this.databaseURL, this.storageBucket, this.measurementId, this.trackingId, this.deepLinkURLScheme, this.androidClientId, this.iosClientId, this.iosBundleId, this.appGroupId);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(14);
            toListResult.add(this.apiKey);
            toListResult.add(this.appId);
            toListResult.add(this.messagingSenderId);
            toListResult.add(this.projectId);
            toListResult.add(this.authDomain);
            toListResult.add(this.databaseURL);
            toListResult.add(this.storageBucket);
            toListResult.add(this.measurementId);
            toListResult.add(this.trackingId);
            toListResult.add(this.deepLinkURLScheme);
            toListResult.add(this.androidClientId);
            toListResult.add(this.iosClientId);
            toListResult.add(this.iosBundleId);
            toListResult.add(this.appGroupId);
            return toListResult;
        }

        @NonNull
        static CoreFirebaseOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            CoreFirebaseOptions pigeonResult = new CoreFirebaseOptions();
            Object apiKey = pigeonVar_list.get(0);
            pigeonResult.setApiKey((String)apiKey);
            Object appId = pigeonVar_list.get(1);
            pigeonResult.setAppId((String)appId);
            Object messagingSenderId = pigeonVar_list.get(2);
            pigeonResult.setMessagingSenderId((String)messagingSenderId);
            Object projectId = pigeonVar_list.get(3);
            pigeonResult.setProjectId((String)projectId);
            Object authDomain = pigeonVar_list.get(4);
            pigeonResult.setAuthDomain((String)authDomain);
            Object databaseURL = pigeonVar_list.get(5);
            pigeonResult.setDatabaseURL((String)databaseURL);
            Object storageBucket = pigeonVar_list.get(6);
            pigeonResult.setStorageBucket((String)storageBucket);
            Object measurementId = pigeonVar_list.get(7);
            pigeonResult.setMeasurementId((String)measurementId);
            Object trackingId = pigeonVar_list.get(8);
            pigeonResult.setTrackingId((String)trackingId);
            Object deepLinkURLScheme = pigeonVar_list.get(9);
            pigeonResult.setDeepLinkURLScheme((String)deepLinkURLScheme);
            Object androidClientId = pigeonVar_list.get(10);
            pigeonResult.setAndroidClientId((String)androidClientId);
            Object iosClientId = pigeonVar_list.get(11);
            pigeonResult.setIosClientId((String)iosClientId);
            Object iosBundleId = pigeonVar_list.get(12);
            pigeonResult.setIosBundleId((String)iosBundleId);
            Object appGroupId = pigeonVar_list.get(13);
            pigeonResult.setAppGroupId((String)appGroupId);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String apiKey;
            @Nullable
            private String appId;
            @Nullable
            private String messagingSenderId;
            @Nullable
            private String projectId;
            @Nullable
            private String authDomain;
            @Nullable
            private String databaseURL;
            @Nullable
            private String storageBucket;
            @Nullable
            private String measurementId;
            @Nullable
            private String trackingId;
            @Nullable
            private String deepLinkURLScheme;
            @Nullable
            private String androidClientId;
            @Nullable
            private String iosClientId;
            @Nullable
            private String iosBundleId;
            @Nullable
            private String appGroupId;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setApiKey(@NonNull String setterArg) {
                this.apiKey = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAppId(@NonNull String setterArg) {
                this.appId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMessagingSenderId(@NonNull String setterArg) {
                this.messagingSenderId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setProjectId(@NonNull String setterArg) {
                this.projectId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAuthDomain(@Nullable String setterArg) {
                this.authDomain = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDatabaseURL(@Nullable String setterArg) {
                this.databaseURL = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setStorageBucket(@Nullable String setterArg) {
                this.storageBucket = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMeasurementId(@Nullable String setterArg) {
                this.measurementId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTrackingId(@Nullable String setterArg) {
                this.trackingId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDeepLinkURLScheme(@Nullable String setterArg) {
                this.deepLinkURLScheme = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAndroidClientId(@Nullable String setterArg) {
                this.androidClientId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIosClientId(@Nullable String setterArg) {
                this.iosClientId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIosBundleId(@Nullable String setterArg) {
                this.iosBundleId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAppGroupId(@Nullable String setterArg) {
                this.appGroupId = setterArg;
                return this;
            }

            @NonNull
            public CoreFirebaseOptions build() {
                CoreFirebaseOptions pigeonReturn = new CoreFirebaseOptions();
                pigeonReturn.setApiKey(this.apiKey);
                pigeonReturn.setAppId(this.appId);
                pigeonReturn.setMessagingSenderId(this.messagingSenderId);
                pigeonReturn.setProjectId(this.projectId);
                pigeonReturn.setAuthDomain(this.authDomain);
                pigeonReturn.setDatabaseURL(this.databaseURL);
                pigeonReturn.setStorageBucket(this.storageBucket);
                pigeonReturn.setMeasurementId(this.measurementId);
                pigeonReturn.setTrackingId(this.trackingId);
                pigeonReturn.setDeepLinkURLScheme(this.deepLinkURLScheme);
                pigeonReturn.setAndroidClientId(this.androidClientId);
                pigeonReturn.setIosClientId(this.iosClientId);
                pigeonReturn.setIosBundleId(this.iosBundleId);
                pigeonReturn.setAppGroupId(this.appGroupId);
                return pigeonReturn;
            }
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    static @interface CanIgnoreReturnValue {
    }
}

