/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingBackgroundExecutor;
import io.flutter.plugins.firebase.messaging.JobIntentService;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class FlutterFirebaseMessagingBackgroundService
extends JobIntentService {
    private static final String TAG = "FLTFireMsgService";
    private static final List<Intent> messagingQueue = Collections.synchronizedList(new LinkedList());
    private static FlutterFirebaseMessagingBackgroundExecutor flutterBackgroundExecutor;

    public static void enqueueMessageProcessing(Context context, Intent messageIntent, boolean isHighPriority) {
        FlutterFirebaseMessagingBackgroundService.enqueueWork(context, FlutterFirebaseMessagingBackgroundService.class, 2020, messageIntent, isHighPriority);
    }

    public static void startBackgroundIsolate(long callbackHandle, FlutterShellArgs shellArgs) {
        if (flutterBackgroundExecutor != null) {
            Log.w((String)TAG, (String)"Attempted to start a duplicate background isolate. Returning...");
            return;
        }
        flutterBackgroundExecutor = new FlutterFirebaseMessagingBackgroundExecutor();
        flutterBackgroundExecutor.startBackgroundIsolate(callbackHandle, shellArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onInitialized() {
        Log.i((String)TAG, (String)"FlutterFirebaseMessagingBackgroundService started!");
        List<Intent> list = messagingQueue;
        synchronized (list) {
            for (Intent intent : messagingQueue) {
                flutterBackgroundExecutor.executeDartCallbackInBackgroundIsolate(intent, null);
            }
            messagingQueue.clear();
        }
    }

    public static void setCallbackDispatcher(long callbackHandle) {
        FlutterFirebaseMessagingBackgroundExecutor.setCallbackDispatcher(callbackHandle);
    }

    public static void setUserCallbackHandle(long callbackHandle) {
        FlutterFirebaseMessagingBackgroundExecutor.setUserCallbackHandle(callbackHandle);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        if (flutterBackgroundExecutor == null) {
            flutterBackgroundExecutor = new FlutterFirebaseMessagingBackgroundExecutor();
        }
        flutterBackgroundExecutor.startBackgroundIsolate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onHandleWork(@NonNull Intent intent) {
        if (!flutterBackgroundExecutor.isDartBackgroundHandlerRegistered()) {
            Log.w((String)TAG, (String)"A background message could not be handled in Dart as no onBackgroundMessage handler has been registered.");
            return;
        }
        List<Intent> list = messagingQueue;
        synchronized (list) {
            if (flutterBackgroundExecutor.isNotRunning()) {
                Log.i((String)TAG, (String)"Service has not yet started, messages will be queued.");
                messagingQueue.add(intent);
                return;
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        new Handler(this.getMainLooper()).post(() -> flutterBackgroundExecutor.executeDartCallbackInBackgroundIsolate(intent, latch));
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Log.i((String)TAG, (String)"Exception waiting to execute Dart callback", (Throwable)ex);
        }
    }
}

