/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.messaging;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class FlutterFirebaseMessagingUtils {
    static final String IS_AUTO_INIT_ENABLED = "isAutoInitEnabled";
    static final String SHARED_PREFERENCES_KEY = "io.flutter.firebase.messaging.callback";
    static final String EXTRA_REMOTE_MESSAGE = "notification";
    static final int JOB_ID = 2020;
    private static final String KEY_COLLAPSE_KEY = "collapseKey";
    private static final String KEY_DATA = "data";
    private static final String KEY_FROM = "from";
    private static final String KEY_MESSAGE_ID = "messageId";
    private static final String KEY_MESSAGE_TYPE = "messageType";
    private static final String KEY_SENT_TIME = "sentTime";
    private static final String KEY_TO = "to";
    private static final String KEY_TTL = "ttl";

    FlutterFirebaseMessagingUtils() {
    }

    static Map<String, Object> remoteMessageToMap(RemoteMessage remoteMessage) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        HashMap dataMap = new HashMap();
        if (remoteMessage.getCollapseKey() != null) {
            messageMap.put(KEY_COLLAPSE_KEY, remoteMessage.getCollapseKey());
        }
        if (remoteMessage.getFrom() != null) {
            messageMap.put(KEY_FROM, remoteMessage.getFrom());
        }
        if (remoteMessage.getTo() != null) {
            messageMap.put(KEY_TO, remoteMessage.getTo());
        }
        if (remoteMessage.getMessageId() != null) {
            messageMap.put(KEY_MESSAGE_ID, remoteMessage.getMessageId());
        }
        if (remoteMessage.getMessageType() != null) {
            messageMap.put(KEY_MESSAGE_TYPE, remoteMessage.getMessageType());
        }
        if (!remoteMessage.getData().isEmpty()) {
            Set entries = remoteMessage.getData().entrySet();
            for (Map.Entry entry : entries) {
                dataMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        messageMap.put(KEY_DATA, dataMap);
        messageMap.put(KEY_TTL, remoteMessage.getTtl());
        messageMap.put(KEY_SENT_TIME, remoteMessage.getSentTime());
        if (remoteMessage.getNotification() != null) {
            messageMap.put(EXTRA_REMOTE_MESSAGE, FlutterFirebaseMessagingUtils.remoteMessageNotificationToMap(remoteMessage.getNotification()));
        }
        return messageMap;
    }

    private static Map<String, Object> remoteMessageNotificationToMap(RemoteMessage.Notification notification) {
        HashMap<String, Object> notificationMap = new HashMap<String, Object>();
        HashMap<String, Object> androidNotificationMap = new HashMap<String, Object>();
        if (notification.getTitle() != null) {
            notificationMap.put("title", notification.getTitle());
        }
        if (notification.getTitleLocalizationKey() != null) {
            notificationMap.put("titleLocKey", notification.getTitleLocalizationKey());
        }
        if (notification.getTitleLocalizationArgs() != null) {
            notificationMap.put("titleLocArgs", Arrays.asList(notification.getTitleLocalizationArgs()));
        }
        if (notification.getBody() != null) {
            notificationMap.put("body", notification.getBody());
        }
        if (notification.getBodyLocalizationKey() != null) {
            notificationMap.put("bodyLocKey", notification.getBodyLocalizationKey());
        }
        if (notification.getBodyLocalizationArgs() != null) {
            notificationMap.put("bodyLocArgs", Arrays.asList(notification.getBodyLocalizationArgs()));
        }
        if (notification.getChannelId() != null) {
            androidNotificationMap.put("channelId", notification.getChannelId());
        }
        if (notification.getClickAction() != null) {
            androidNotificationMap.put("clickAction", notification.getClickAction());
        }
        if (notification.getColor() != null) {
            androidNotificationMap.put("color", notification.getColor());
        }
        if (notification.getIcon() != null) {
            androidNotificationMap.put("smallIcon", notification.getIcon());
        }
        if (notification.getImageUrl() != null) {
            androidNotificationMap.put("imageUrl", notification.getImageUrl().toString());
        }
        if (notification.getLink() != null) {
            androidNotificationMap.put("link", notification.getLink().toString());
        }
        if (notification.getNotificationCount() != null) {
            androidNotificationMap.put("count", notification.getNotificationCount());
        }
        if (notification.getNotificationPriority() != null) {
            androidNotificationMap.put("priority", notification.getNotificationPriority());
        }
        if (notification.getSound() != null) {
            androidNotificationMap.put("sound", notification.getSound());
        }
        if (notification.getTicker() != null) {
            androidNotificationMap.put("ticker", notification.getTicker());
        }
        if (notification.getVisibility() != null) {
            androidNotificationMap.put("visibility", notification.getVisibility());
        }
        if (notification.getTag() != null) {
            androidNotificationMap.put("tag", notification.getTag());
        }
        notificationMap.put("android", androidNotificationMap);
        return notificationMap;
    }

    static boolean isApplicationForeground(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        if (keyguardManager != null && keyguardManager.isKeyguardLocked()) {
            return false;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    static FirebaseMessaging getFirebaseMessagingForArguments(Map<String, Object> arguments) {
        return FirebaseMessaging.getInstance();
    }

    static RemoteMessage getRemoteMessageForArguments(Map<String, Object> arguments) {
        Map messageMap = (Map)Objects.requireNonNull(arguments.get("message"));
        String to = (String)Objects.requireNonNull(messageMap.get(KEY_TO));
        RemoteMessage.Builder builder = new RemoteMessage.Builder(to);
        String collapseKey = (String)messageMap.get(KEY_COLLAPSE_KEY);
        String messageId = (String)messageMap.get(KEY_MESSAGE_ID);
        String messageType = (String)messageMap.get(KEY_MESSAGE_TYPE);
        Integer ttl = (Integer)messageMap.get(KEY_TTL);
        Map data = (Map)messageMap.get(KEY_DATA);
        if (collapseKey != null) {
            builder.setCollapseKey(collapseKey);
        }
        if (messageType != null) {
            builder.setMessageType(messageType);
        }
        if (messageId != null) {
            builder.setMessageId(messageId);
        }
        if (ttl != null) {
            builder.setTtl(ttl.intValue());
        }
        if (data != null) {
            builder.setData(data);
        }
        return builder.build();
    }

    static Map<String, Object> getRemoteMessageNotificationForArguments(Map<String, Object> arguments) {
        Map messageMap = (Map)Objects.requireNonNull(arguments.get("message"));
        if (messageMap.get(EXTRA_REMOTE_MESSAGE) == null) {
            return null;
        }
        Map notification = (Map)messageMap.get(EXTRA_REMOTE_MESSAGE);
        return notification;
    }
}

