/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.messaging;

import android.content.SharedPreferences;
import com.google.firebase.messaging.RemoteMessage;
import io.flutter.plugins.firebase.messaging.ContextHolder;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FlutterFirebaseMessagingStore {
    private static final String PREFERENCES_FILE = "io.flutter.plugins.firebase.messaging";
    private static final String KEY_NOTIFICATION_IDS = "notification_ids";
    private static final int MAX_SIZE_NOTIFICATIONS = 100;
    private static FlutterFirebaseMessagingStore instance;
    private final String DELIMITER = ",";
    private SharedPreferences preferences;

    public static FlutterFirebaseMessagingStore getInstance() {
        if (instance == null) {
            instance = new FlutterFirebaseMessagingStore();
        }
        return instance;
    }

    private SharedPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = ContextHolder.getApplicationContext().getSharedPreferences(PREFERENCES_FILE, 0);
        }
        return this.preferences;
    }

    public void setPreferencesStringValue(String key, String value) {
        this.getPreferences().edit().putString(key, value).apply();
    }

    public String getPreferencesStringValue(String key, String defaultValue) {
        return this.getPreferences().getString(key, defaultValue);
    }

    public void storeFirebaseMessage(RemoteMessage remoteMessage) {
        String remoteMessageString = new JSONObject(FlutterFirebaseMessagingUtils.remoteMessageToMap(remoteMessage)).toString();
        this.setPreferencesStringValue(remoteMessage.getMessageId(), remoteMessageString);
        String notifications = this.getPreferencesStringValue(KEY_NOTIFICATION_IDS, "");
        notifications = notifications + remoteMessage.getMessageId() + ",";
        ArrayList<String> allNotificationList = new ArrayList<String>(Arrays.asList(notifications.split(",")));
        if (allNotificationList.size() > 100) {
            String firstRemoteMessageId = (String)allNotificationList.get(0);
            this.getPreferences().edit().remove(firstRemoteMessageId).apply();
            notifications = notifications.replace(firstRemoteMessageId + ",", "");
        }
        this.setPreferencesStringValue(KEY_NOTIFICATION_IDS, notifications);
    }

    public Map<String, Object> getFirebaseMessageMap(String remoteMessageId) {
        String remoteMessageString = this.getPreferencesStringValue(remoteMessageId, null);
        if (remoteMessageString != null) {
            try {
                HashMap<String, Object> argumentsMap = new HashMap<String, Object>(1);
                Map<String, Object> messageOutMap = this.jsonObjectToMap(new JSONObject(remoteMessageString));
                messageOutMap.put("to", remoteMessageId);
                argumentsMap.put("message", messageOutMap);
                return argumentsMap;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void removeFirebaseMessage(String remoteMessageId) {
        this.getPreferences().edit().remove(remoteMessageId).apply();
        String notifications = this.getPreferencesStringValue(KEY_NOTIFICATION_IDS, "");
        if (!notifications.isEmpty()) {
            notifications = notifications.replace(remoteMessageId + ",", "");
            this.setPreferencesStringValue(KEY_NOTIFICATION_IDS, notifications);
        }
    }

    private Map<String, Object> jsonObjectToMap(JSONObject jsonObject) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = jsonObject.get(key);
            if (value instanceof JSONArray) {
                value = this.jsonArrayToList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = this.jsonObjectToMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public List<Object> jsonArrayToList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = this.jsonArrayToList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = this.jsonObjectToMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

