/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipher;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipherFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

public class FlutterSecureStorage {
    private final String TAG = "SecureStorageAndroid";
    private final Charset charset;
    private final Context applicationContext;
    protected String ELEMENT_PREFERENCES_KEY_PREFIX = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIHNlY3VyZSBzdG9yYWdlCg";
    protected Map<String, Object> options;
    private String SHARED_PREFERENCES_NAME = "FlutterSecureStorage";
    private SharedPreferences preferences;
    private StorageCipher storageCipher;
    private StorageCipherFactory storageCipherFactory;
    private Boolean failedToUseEncryptedSharedPreferences = false;

    public FlutterSecureStorage(Context context, Map<String, Object> options) {
        this.options = options;
        this.applicationContext = context.getApplicationContext();
        this.charset = Build.VERSION.SDK_INT >= 19 ? StandardCharsets.UTF_8 : Charset.forName("UTF-8");
    }

    boolean getResetOnError() {
        return this.options.containsKey("resetOnError") && this.options.get("resetOnError").equals("true");
    }

    private boolean getUseEncryptedSharedPreferences() {
        if (this.failedToUseEncryptedSharedPreferences.booleanValue()) {
            return false;
        }
        return this.options.containsKey("encryptedSharedPreferences") && this.options.get("encryptedSharedPreferences").equals("true") && Build.VERSION.SDK_INT >= 23;
    }

    public boolean containsKey(String key) {
        this.ensureInitialized();
        return this.preferences.contains(key);
    }

    public String addPrefixToKey(String key) {
        return this.ELEMENT_PREFERENCES_KEY_PREFIX + "_" + key;
    }

    public String read(String key) throws Exception {
        this.ensureInitialized();
        String rawValue = this.preferences.getString(key, null);
        if (this.getUseEncryptedSharedPreferences()) {
            return rawValue;
        }
        return this.decodeRawValue(rawValue);
    }

    public Map<String, String> readAll() throws Exception {
        this.ensureInitialized();
        Map raw = this.preferences.getAll();
        HashMap<String, String> all = new HashMap<String, String>();
        for (Map.Entry entry : raw.entrySet()) {
            String keyWithPrefix = (String)entry.getKey();
            if (!keyWithPrefix.contains(this.ELEMENT_PREFERENCES_KEY_PREFIX)) continue;
            String key = ((String)entry.getKey()).replaceFirst(this.ELEMENT_PREFERENCES_KEY_PREFIX + '_', "");
            if (this.getUseEncryptedSharedPreferences()) {
                all.put(key, (String)entry.getValue());
                continue;
            }
            String rawValue = (String)entry.getValue();
            String value = this.decodeRawValue(rawValue);
            all.put(key, value);
        }
        return all;
    }

    public void write(String key, String value) throws Exception {
        this.ensureInitialized();
        SharedPreferences.Editor editor = this.preferences.edit();
        if (this.getUseEncryptedSharedPreferences()) {
            editor.putString(key, value);
        } else {
            byte[] result = this.storageCipher.encrypt(value.getBytes(this.charset));
            editor.putString(key, Base64.encodeToString((byte[])result, (int)0));
        }
        editor.apply();
    }

    public void delete(String key) {
        this.ensureInitialized();
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.remove(key);
        editor.apply();
    }

    public void deleteAll() {
        this.ensureInitialized();
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.clear();
        if (!this.getUseEncryptedSharedPreferences()) {
            this.storageCipherFactory.storeCurrentAlgorithms(editor);
        }
        editor.apply();
    }

    protected void ensureOptions() {
        if (this.options.containsKey("sharedPreferencesName") && !((String)this.options.get("sharedPreferencesName")).isEmpty()) {
            this.SHARED_PREFERENCES_NAME = (String)this.options.get("sharedPreferencesName");
        }
        if (this.options.containsKey("preferencesKeyPrefix") && !((String)this.options.get("preferencesKeyPrefix")).isEmpty()) {
            this.ELEMENT_PREFERENCES_KEY_PREFIX = (String)this.options.get("preferencesKeyPrefix");
        }
    }

    private void ensureInitialized() {
        this.ensureOptions();
        SharedPreferences nonEncryptedPreferences = this.applicationContext.getSharedPreferences(this.SHARED_PREFERENCES_NAME, 0);
        if (this.storageCipher == null) {
            try {
                this.initStorageCipher(nonEncryptedPreferences);
            }
            catch (Exception e) {
                Log.e((String)"SecureStorageAndroid", (String)"StorageCipher initialization failed", (Throwable)e);
            }
        }
        if (this.getUseEncryptedSharedPreferences() && Build.VERSION.SDK_INT >= 23) {
            try {
                this.preferences = this.initializeEncryptedSharedPreferencesManager(this.applicationContext);
                this.checkAndMigrateToEncrypted(nonEncryptedPreferences, this.preferences);
            }
            catch (Exception e) {
                Log.e((String)"SecureStorageAndroid", (String)"EncryptedSharedPreferences initialization failed", (Throwable)e);
                this.preferences = nonEncryptedPreferences;
                this.failedToUseEncryptedSharedPreferences = true;
            }
        } else {
            this.preferences = nonEncryptedPreferences;
        }
    }

    private void initStorageCipher(SharedPreferences source) throws Exception {
        this.storageCipherFactory = new StorageCipherFactory(source, this.options);
        if (this.getUseEncryptedSharedPreferences()) {
            this.storageCipher = this.storageCipherFactory.getSavedStorageCipher(this.applicationContext);
        } else if (this.storageCipherFactory.requiresReEncryption()) {
            this.reEncryptPreferences(this.storageCipherFactory, source);
        } else {
            this.storageCipher = this.storageCipherFactory.getCurrentStorageCipher(this.applicationContext);
        }
    }

    private void reEncryptPreferences(StorageCipherFactory storageCipherFactory, SharedPreferences source) throws Exception {
        try {
            this.storageCipher = storageCipherFactory.getSavedStorageCipher(this.applicationContext);
            HashMap<String, String> cache = new HashMap<String, String>();
            for (Map.Entry entry : source.getAll().entrySet()) {
                Object v = entry.getValue();
                String key = (String)entry.getKey();
                if (!(v instanceof String) || !key.contains(this.ELEMENT_PREFERENCES_KEY_PREFIX)) continue;
                String decodedValue = this.decodeRawValue((String)v);
                cache.put(key, decodedValue);
            }
            this.storageCipher = storageCipherFactory.getCurrentStorageCipher(this.applicationContext);
            SharedPreferences.Editor editor = source.edit();
            for (Map.Entry entry : cache.entrySet()) {
                byte[] result = this.storageCipher.encrypt(((String)entry.getValue()).getBytes(this.charset));
                editor.putString((String)entry.getKey(), Base64.encodeToString((byte[])result, (int)0));
            }
            storageCipherFactory.storeCurrentAlgorithms(editor);
            editor.apply();
        }
        catch (Exception e) {
            Log.e((String)"SecureStorageAndroid", (String)"re-encryption failed", (Throwable)e);
            this.storageCipher = storageCipherFactory.getSavedStorageCipher(this.applicationContext);
        }
    }

    private void checkAndMigrateToEncrypted(SharedPreferences source, SharedPreferences target) {
        try {
            for (Map.Entry entry : source.getAll().entrySet()) {
                Object v = entry.getValue();
                String key = (String)entry.getKey();
                if (!(v instanceof String) || !key.contains(this.ELEMENT_PREFERENCES_KEY_PREFIX)) continue;
                String decodedValue = this.decodeRawValue((String)v);
                target.edit().putString(key, decodedValue).apply();
                source.edit().remove(key).apply();
            }
            SharedPreferences.Editor sourceEditor = source.edit();
            this.storageCipherFactory.removeCurrentAlgorithms(sourceEditor);
            sourceEditor.apply();
        }
        catch (Exception e) {
            Log.e((String)"SecureStorageAndroid", (String)"Data migration failed", (Throwable)e);
        }
    }

    @RequiresApi(api=23)
    private SharedPreferences initializeEncryptedSharedPreferencesManager(Context context) throws GeneralSecurityException, IOException {
        MasterKey key = new MasterKey.Builder(context).setKeyGenParameterSpec(new KeyGenParameterSpec.Builder("_androidx_security_master_key_", 3).setEncryptionPaddings(new String[]{"NoPadding"}).setBlockModes(new String[]{"GCM"}).setKeySize(256).build()).build();
        return EncryptedSharedPreferences.create((Context)context, (String)this.SHARED_PREFERENCES_NAME, (MasterKey)key, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
    }

    private String decodeRawValue(String value) throws Exception {
        if (value == null) {
            return null;
        }
        byte[] data = Base64.decode((String)value, (int)0);
        byte[] result = this.storageCipher.decrypt(data);
        return new String(result, this.charset);
    }
}

