/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geocoding;

import android.location.Address;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baseflow.geocoding.GeocodeListenerAdapter;
import com.baseflow.geocoding.Geocoding;
import com.baseflow.geocoding.utils.AddressMapper;
import com.baseflow.geocoding.utils.LocaleConverter;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.List;
import java.util.Locale;

final class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    private static final String TAG = "MethodCallHandlerImpl";
    private final Geocoding geocoding;
    @Nullable
    private MethodChannel channel;

    MethodCallHandlerImpl(Geocoding geocoding) {
        this.geocoding = geocoding;
    }

    public void onMethodCall(MethodCall call, @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "setLocaleIdentifier": {
                this.setLocaleIdentifier(call, result);
                break;
            }
            case "locationFromAddress": {
                this.onLocationFromAddress(call, result);
                break;
            }
            case "placemarkFromAddress": {
                this.onPlacemarkFromAddress(call, result);
                break;
            }
            case "placemarkFromCoordinates": {
                this.onPlacemarkFromCoordinates(call, result);
                break;
            }
            case "isPresent": {
                this.onIsPresent(call, result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void startListening(BinaryMessenger messenger) {
        if (this.channel != null) {
            Log.wtf((String)TAG, (String)"Setting a method call handler before the last was disposed.");
            this.stopListening();
        }
        BinaryMessenger.TaskQueue taskQueue = messenger.makeBackgroundTaskQueue();
        this.channel = new MethodChannel(messenger, "flutter.baseflow.com/geocoding", (MethodCodec)StandardMethodCodec.INSTANCE, taskQueue);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    void stopListening() {
        if (this.channel == null) {
            Log.d((String)TAG, (String)"Tried to stop listening when no MethodChannel had been initialized.");
            return;
        }
        this.channel.setMethodCallHandler(null);
        this.channel = null;
    }

    private void setLocaleIdentifier(MethodCall call, MethodChannel.Result result) {
        String languageTag = (String)call.argument("localeIdentifier");
        this.geocoding.setLocaleIdentifier(LocaleConverter.fromLanguageTag(languageTag));
        result.success((Object)true);
    }

    private void onLocationFromAddress(MethodCall call, final MethodChannel.Result result) {
        final String address = (String)call.argument("address");
        if (address == null || address.isEmpty()) {
            result.error("ARGUMENT_ERROR", "Supply a valid value for the 'address' parameter.", null);
        }
        this.geocoding.placemarkFromAddress(address, new GeocodeListenerAdapter(){

            @Override
            public void onGeocode(List<Address> addresses) {
                if (addresses != null && addresses.size() > 0) {
                    result.success(AddressMapper.toLocationHashMapList(addresses));
                } else {
                    result.error("NOT_FOUND", String.format("No coordinates found for '%s'", address), null);
                }
            }

            @Override
            public void onError(@Nullable String errorMessage) {
                result.error("IO_ERROR", errorMessage != null ? errorMessage : "Unknown error occurred", null);
            }
        });
    }

    private void onPlacemarkFromAddress(MethodCall call, final MethodChannel.Result result) {
        final String address = (String)call.argument("address");
        if (address == null || address.isEmpty()) {
            result.error("ARGUMENT_ERROR", "Supply a valid value for the 'address' parameter.", null);
        }
        this.geocoding.placemarkFromAddress(address, new GeocodeListenerAdapter(){

            @Override
            public void onGeocode(List<Address> addresses) {
                if (addresses != null && addresses.size() > 0) {
                    result.success(AddressMapper.toAddressHashMapList(addresses));
                } else {
                    result.error("NOT_FOUND", String.format("No coordinates found for '%s'", address), null);
                }
            }

            @Override
            public void onError(@Nullable String errorMessage) {
                result.error("IO_ERROR", errorMessage != null ? errorMessage : "Unknown error occurred", null);
            }
        });
    }

    private void onPlacemarkFromCoordinates(MethodCall call, final MethodChannel.Result result) {
        final double latitude = (Double)call.argument("latitude");
        final double longitude = (Double)call.argument("longitude");
        this.geocoding.placemarkFromCoordinates(latitude, longitude, new GeocodeListenerAdapter(){

            @Override
            public void onGeocode(List<Address> addresses) {
                if (addresses != null && addresses.size() > 0) {
                    result.success(AddressMapper.toAddressHashMapList(addresses));
                } else {
                    result.error("NOT_FOUND", String.format(Locale.ENGLISH, "No address information found for supplied coordinates (latitude: %f, longitude: %f).", latitude, longitude), null);
                }
            }

            @Override
            public void onError(@Nullable String errorMessage) {
                result.error("IO_ERROR", errorMessage != null ? errorMessage : "Unknown error occurred", null);
            }
        });
    }

    private void onIsPresent(MethodCall call, MethodChannel.Result result) {
        boolean isPresent = this.geocoding.isPresent();
        result.success((Object)isPresent);
    }
}

