/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.location;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.baseflow.geolocator.location.ForegroundNotificationOptions;

public class BackgroundNotification {
    @NonNull
    private final Context context;
    @NonNull
    private final Integer notificationId;
    @NonNull
    private final String channelId;
    @NonNull
    private NotificationCompat.Builder builder;

    public BackgroundNotification(@NonNull Context context, @NonNull String channelId, @NonNull Integer notificationId, ForegroundNotificationOptions options) {
        this.context = context;
        this.notificationId = notificationId;
        this.channelId = channelId;
        this.builder = new NotificationCompat.Builder(context, channelId).setPriority(1);
        this.updateNotification(options, false);
    }

    private int getDrawableId(String iconName, String defType) {
        return this.context.getResources().getIdentifier(iconName, defType, this.context.getPackageName());
    }

    @SuppressLint(value={"UnspecifiedImmutableFlag"})
    private PendingIntent buildBringToFrontIntent() {
        Intent intent = this.context.getPackageManager().getLaunchIntentForPackage(this.context.getPackageName());
        if (intent != null) {
            intent.setPackage(null);
            intent.setFlags(0x10200000);
            int flags = 0x8000000;
            if (Build.VERSION.SDK_INT > 23) {
                flags |= 0x4000000;
            }
            return PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)flags);
        }
        return null;
    }

    public void updateChannel(String channelName) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
            NotificationChannel channel = new NotificationChannel(this.channelId, (CharSequence)channelName, 0);
            channel.setLockscreenVisibility(0);
            notificationManager.createNotificationChannel(channel);
        }
    }

    private void updateNotification(ForegroundNotificationOptions options, boolean notify) {
        int iconId = this.getDrawableId(options.getNotificationIcon().getName(), options.getNotificationIcon().getDefType());
        if (iconId == 0) {
            this.getDrawableId("ic_launcher.png", "mipmap");
        }
        this.builder = this.builder.setContentTitle((CharSequence)options.getNotificationTitle()).setSmallIcon(iconId).setContentText((CharSequence)options.getNotificationText()).setContentIntent(this.buildBringToFrontIntent()).setOngoing(options.isSetOngoing());
        Integer notificationColor = options.getColor();
        if (notificationColor != null) {
            this.builder = this.builder.setColor(notificationColor.intValue());
        }
        if (notify) {
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
            notificationManager.notify(this.notificationId.intValue(), this.builder.build());
        }
    }

    public void updateOptions(ForegroundNotificationOptions options, boolean isVisible) {
        this.updateNotification(options, isVisible);
    }

    public Notification build() {
        return this.builder.build();
    }
}

