/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.location;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.location.LocationListenerCompat;
import androidx.core.location.LocationManagerCompat;
import androidx.core.location.LocationRequestCompat;
import com.baseflow.geolocator.errors.ErrorCallback;
import com.baseflow.geolocator.errors.ErrorCodes;
import com.baseflow.geolocator.location.LocationAccuracy;
import com.baseflow.geolocator.location.LocationClient;
import com.baseflow.geolocator.location.LocationOptions;
import com.baseflow.geolocator.location.LocationServiceListener;
import com.baseflow.geolocator.location.NmeaClient;
import com.baseflow.geolocator.location.PositionChangedCallback;
import java.util.List;

class LocationManagerClient
implements LocationClient,
LocationListenerCompat {
    private static final long TWO_MINUTES = 120000L;
    private final LocationManager locationManager;
    private final NmeaClient nmeaClient;
    @Nullable
    private final LocationOptions locationOptions;
    public Context context;
    private boolean isListening = false;
    @Nullable
    private Location currentBestLocation;
    @Nullable
    private String currentLocationProvider;
    @Nullable
    private PositionChangedCallback positionChangedCallback;
    @Nullable
    private ErrorCallback errorCallback;

    public LocationManagerClient(@NonNull Context context, @Nullable LocationOptions locationOptions) {
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.locationOptions = locationOptions;
        this.context = context;
        this.nmeaClient = new NmeaClient(context, locationOptions);
    }

    static boolean isBetterLocation(Location location, Location bestLocation) {
        boolean isNewer;
        if (bestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - bestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 120000L;
        boolean isSignificantlyOlder = timeDelta < -120000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        float accuracyDelta = (int)(location.getAccuracy() - bestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0.0f;
        boolean isMoreAccurate = accuracyDelta < 0.0f;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200.0f;
        boolean isFromSameProvider = false;
        if (location.getProvider() != null) {
            isFromSameProvider = location.getProvider().equals(bestLocation.getProvider());
        }
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    @Nullable
    private static String determineProvider(@NonNull LocationManager locationManager, @NonNull LocationAccuracy accuracy) {
        List enabledProviders = locationManager.getProviders(true);
        if (accuracy == LocationAccuracy.lowest) {
            return "passive";
        }
        if (enabledProviders.contains("fused") && Build.VERSION.SDK_INT >= 31) {
            return "fused";
        }
        if (enabledProviders.contains("gps")) {
            return "gps";
        }
        if (enabledProviders.contains("network")) {
            return "network";
        }
        if (!enabledProviders.isEmpty()) {
            return (String)enabledProviders.get(0);
        }
        return null;
    }

    private static int accuracyToQuality(@NonNull LocationAccuracy accuracy) {
        switch (accuracy) {
            case lowest: 
            case low: {
                return 104;
            }
            case high: 
            case best: 
            case bestForNavigation: {
                return 100;
            }
        }
        return 102;
    }

    @Override
    public void isLocationServiceEnabled(LocationServiceListener listener) {
        if (this.locationManager == null) {
            listener.onLocationServiceResult(false);
            return;
        }
        listener.onLocationServiceResult(this.checkLocationService(this.context));
    }

    @Override
    public void getLastKnownPosition(PositionChangedCallback positionChangedCallback, ErrorCallback errorCallback) {
        Location bestLocation = null;
        for (String provider : this.locationManager.getProviders(true)) {
            Location location = this.locationManager.getLastKnownLocation(provider);
            if (location == null || !LocationManagerClient.isBetterLocation(location, bestLocation)) continue;
            bestLocation = location;
        }
        positionChangedCallback.onPositionChanged(bestLocation);
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode) {
        return false;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void startPositionUpdates(Activity activity, PositionChangedCallback positionChangedCallback, ErrorCallback errorCallback) {
        if (!this.checkLocationService(this.context)) {
            errorCallback.onError(ErrorCodes.locationServicesDisabled);
            return;
        }
        this.positionChangedCallback = positionChangedCallback;
        this.errorCallback = errorCallback;
        LocationAccuracy accuracy = LocationAccuracy.best;
        long timeInterval = 0L;
        float distanceFilter = 0.0f;
        int quality = 102;
        if (this.locationOptions != null) {
            distanceFilter = this.locationOptions.getDistanceFilter();
            accuracy = this.locationOptions.getAccuracy();
            timeInterval = accuracy == LocationAccuracy.lowest ? Long.MAX_VALUE : this.locationOptions.getTimeInterval();
            quality = LocationManagerClient.accuracyToQuality(accuracy);
        }
        this.currentLocationProvider = LocationManagerClient.determineProvider(this.locationManager, accuracy);
        if (this.currentLocationProvider == null) {
            errorCallback.onError(ErrorCodes.locationServicesDisabled);
            return;
        }
        LocationRequestCompat locationRequest = new LocationRequestCompat.Builder(timeInterval).setMinUpdateDistanceMeters(distanceFilter).setMinUpdateIntervalMillis(timeInterval).setQuality(quality).build();
        this.isListening = true;
        this.nmeaClient.start();
        LocationManagerCompat.requestLocationUpdates((LocationManager)this.locationManager, (String)this.currentLocationProvider, (LocationRequestCompat)locationRequest, (LocationListenerCompat)this, (Looper)Looper.getMainLooper());
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void stopPositionUpdates() {
        this.isListening = false;
        this.nmeaClient.stop();
        this.locationManager.removeUpdates((LocationListener)this);
    }

    public synchronized void onLocationChanged(Location location) {
        if (LocationManagerClient.isBetterLocation(location, this.currentBestLocation)) {
            this.currentBestLocation = location;
            if (this.positionChangedCallback != null) {
                this.nmeaClient.enrichExtrasWithNmea(location);
                this.positionChangedCallback.onPositionChanged(this.currentBestLocation);
            }
        }
    }

    @TargetApi(value=28)
    public void onStatusChanged(@NonNull String provider, int status, Bundle extras) {
        if (status == 2) {
            this.onProviderEnabled(provider);
        } else if (status == 0) {
            this.onProviderDisabled(provider);
        }
    }

    public void onProviderEnabled(@NonNull String provider) {
    }

    @SuppressLint(value={"MissingPermission"})
    public void onProviderDisabled(String provider) {
        if (provider.equals(this.currentLocationProvider)) {
            if (this.isListening) {
                this.locationManager.removeUpdates((LocationListener)this);
            }
            if (this.errorCallback != null) {
                this.errorCallback.onError(ErrorCodes.locationServicesDisabled);
            }
            this.currentLocationProvider = null;
        }
    }
}

