/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.baseflow.geolocator.location.LocationServiceStatusReceiver;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;

public class LocationServiceHandlerImpl
implements EventChannel.StreamHandler {
    private static final String TAG = "LocationServiceHandler";
    @Nullable
    private EventChannel channel;
    @Nullable
    private Context context;
    @Nullable
    private LocationServiceStatusReceiver receiver;

    void startListening(Context context, BinaryMessenger messenger) {
        if (this.channel != null) {
            Log.w((String)TAG, (String)"Setting a event call handler before the last was disposed.");
            this.stopListening();
        }
        this.channel = new EventChannel(messenger, "flutter.baseflow.com/geolocator_service_updates_android");
        this.channel.setStreamHandler((EventChannel.StreamHandler)this);
        this.context = context;
    }

    void stopListening() {
        if (this.channel == null) {
            return;
        }
        this.disposeListeners();
        this.channel.setStreamHandler(null);
        this.channel = null;
    }

    void setContext(@Nullable Context context) {
        this.context = context;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        if (this.context == null) {
            return;
        }
        IntentFilter filter = new IntentFilter("android.location.PROVIDERS_CHANGED");
        filter.addAction("android.intent.action.PROVIDER_CHANGED");
        this.receiver = new LocationServiceStatusReceiver(events);
        ContextCompat.registerReceiver((Context)this.context, (BroadcastReceiver)this.receiver, (IntentFilter)filter, (int)2);
    }

    public void onCancel(Object arguments) {
        this.disposeListeners();
    }

    private void disposeListeners() {
        if (this.context != null && this.receiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
        }
    }
}

