/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.location;

import android.location.Location;
import android.os.Build;
import java.util.HashMap;
import java.util.Map;

public class LocationMapper {
    public static Map<String, Object> toHashMap(Location location) {
        if (location == null) {
            return null;
        }
        HashMap<String, Object> position = new HashMap<String, Object>();
        position.put("latitude", location.getLatitude());
        position.put("longitude", location.getLongitude());
        position.put("timestamp", location.getTime());
        position.put("is_mocked", LocationMapper.isMocked(location));
        if (location.hasAltitude()) {
            position.put("altitude", location.getAltitude());
        }
        if (Build.VERSION.SDK_INT >= 26 && location.hasVerticalAccuracy()) {
            position.put("altitude_accuracy", Float.valueOf(location.getVerticalAccuracyMeters()));
        }
        if (location.hasAccuracy()) {
            position.put("accuracy", Double.valueOf(location.getAccuracy()));
        }
        if (location.hasBearing()) {
            position.put("heading", Double.valueOf(location.getBearing()));
        }
        if (Build.VERSION.SDK_INT >= 26 && location.hasBearingAccuracy()) {
            position.put("heading_accuracy", Float.valueOf(location.getBearingAccuracyDegrees()));
        }
        if (location.hasSpeed()) {
            position.put("speed", Double.valueOf(location.getSpeed()));
        }
        if (Build.VERSION.SDK_INT >= 26 && location.hasSpeedAccuracy()) {
            position.put("speed_accuracy", location.getSpeedAccuracyMetersPerSecond());
        }
        if (location.getExtras() != null) {
            if (location.getExtras().containsKey("geolocator_mslAltitude")) {
                Double mslAltitude = location.getExtras().getDouble("geolocator_mslAltitude");
                position.put("altitude", mslAltitude);
            }
            if (location.getExtras().containsKey("geolocator_mslSatelliteCount")) {
                Double mslSatelliteCount = location.getExtras().getDouble("geolocator_mslSatelliteCount");
                position.put("gnss_satellite_count", mslSatelliteCount);
            }
            if (location.getExtras().containsKey("geolocator_mslSatellitesUsedInFix")) {
                Double mslSatellitesUsedInFix = location.getExtras().getDouble("geolocator_mslSatellitesUsedInFix");
                position.put("gnss_satellites_used_in_fix", mslSatellitesUsedInFix);
            }
            if (Build.VERSION.SDK_INT >= 34 && location.hasMslAltitude()) {
                double mslAltitude = location.getMslAltitudeMeters();
                position.put("altitude", mslAltitude);
                if (location.hasMslAltitudeAccuracy()) {
                    float mslAccuracy = location.getMslAltitudeAccuracyMeters();
                    position.put("altitude_accuracy", Float.valueOf(mslAccuracy));
                }
            }
        }
        return position;
    }

    private static boolean isMocked(Location location) {
        if (Build.VERSION.SDK_INT >= 31) {
            return location.isMock();
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return location.isFromMockProvider();
        }
        return false;
    }
}

