/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.location;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.location.GnssStatus;
import android.location.Location;
import android.location.LocationManager;
import android.location.OnNmeaMessageListener;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baseflow.geolocator.location.LocationOptions;
import java.util.Calendar;

public class NmeaClient {
    public static final String NMEA_ALTITUDE_EXTRA = "geolocator_mslAltitude";
    public static final String GNSS_SATELLITE_COUNT_EXTRA = "geolocator_mslSatelliteCount";
    public static final String GNSS_SATELLITES_USED_IN_FIX_EXTRA = "geolocator_mslSatellitesUsedInFix";
    private final Context context;
    private final LocationManager locationManager;
    @Nullable
    private final LocationOptions locationOptions;
    @TargetApi(value=24)
    private OnNmeaMessageListener nmeaMessageListener;
    @TargetApi(value=24)
    private GnssStatus.Callback gnssCallback;
    private String lastNmeaMessage;
    private double gnss_satellite_count;
    private double gnss_satellites_used_in_fix;
    @Nullable
    private Calendar lastNmeaMessageTime;
    private boolean listenerAdded = false;

    public NmeaClient(@NonNull Context context, @Nullable LocationOptions locationOptions) {
        this.context = context;
        this.locationOptions = locationOptions;
        this.locationManager = (LocationManager)context.getSystemService("location");
        if (Build.VERSION.SDK_INT >= 24) {
            this.nmeaMessageListener = (message, timestamp) -> {
                if (message.trim().matches("^\\$..GGA.*$")) {
                    this.lastNmeaMessage = message;
                    this.lastNmeaMessageTime = Calendar.getInstance();
                }
            };
            this.gnssCallback = new GnssStatus.Callback(){

                public void onSatelliteStatusChanged(@NonNull GnssStatus status) {
                    NmeaClient.this.gnss_satellite_count = status.getSatelliteCount();
                    NmeaClient.this.gnss_satellites_used_in_fix = 0.0;
                    int i = 0;
                    while ((double)i < NmeaClient.this.gnss_satellite_count) {
                        if (status.usedInFix(i)) {
                            NmeaClient.this.gnss_satellites_used_in_fix += 1.0;
                        }
                        ++i;
                    }
                }
            };
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void start() {
        if (this.listenerAdded) {
            return;
        }
        if (this.locationOptions != null && Build.VERSION.SDK_INT >= 24 && this.locationManager != null && this.context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0) {
            this.locationManager.addNmeaListener(this.nmeaMessageListener, null);
            this.locationManager.registerGnssStatusCallback(this.gnssCallback, null);
            this.listenerAdded = true;
        }
    }

    public void stop() {
        if (this.locationOptions != null && Build.VERSION.SDK_INT >= 24 && this.locationManager != null) {
            this.locationManager.removeNmeaListener(this.nmeaMessageListener);
            this.locationManager.unregisterGnssStatusCallback(this.gnssCallback);
            this.listenerAdded = false;
        }
    }

    public void enrichExtrasWithNmea(@Nullable Location location) {
        if (location == null) {
            return;
        }
        if (location.getExtras() == null) {
            location.setExtras(Bundle.EMPTY);
        }
        location.getExtras().putDouble(GNSS_SATELLITE_COUNT_EXTRA, this.gnss_satellite_count);
        location.getExtras().putDouble(GNSS_SATELLITES_USED_IN_FIX_EXTRA, this.gnss_satellites_used_in_fix);
        if (this.lastNmeaMessage != null && this.locationOptions != null && this.listenerAdded) {
            Calendar expiryDate = Calendar.getInstance();
            expiryDate.add(13, -5);
            if (this.lastNmeaMessageTime != null && this.lastNmeaMessageTime.before(expiryDate)) {
                return;
            }
            if (this.locationOptions.isUseMSLAltitude()) {
                String[] tokens = this.lastNmeaMessage.split(",");
                String type = tokens[0];
                if (this.lastNmeaMessage.trim().matches("^\\$..GGA.*$") && tokens.length > 9 && !tokens[9].isEmpty()) {
                    double mslAltitude = Double.parseDouble(tokens[9]);
                    if (location.getExtras() == null) {
                        location.setExtras(Bundle.EMPTY);
                    }
                    location.getExtras().putDouble(NMEA_ALTITUDE_EXTRA, mslAltitude);
                }
            }
        }
    }
}

