/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Polygon;
import io.flutter.plugins.googlemaps.PolygonOptionsSink;
import java.util.List;

class PolygonController
implements PolygonOptionsSink {
    private final Polygon polygon;
    private final String googleMapsPolygonId;
    private final float density;
    private boolean consumeTapEvents;

    PolygonController(Polygon polygon, boolean consumeTapEvents, float density) {
        this.polygon = polygon;
        this.density = density;
        this.consumeTapEvents = consumeTapEvents;
        this.googleMapsPolygonId = polygon.getId();
    }

    void remove() {
        this.polygon.remove();
    }

    @Override
    public void setConsumeTapEvents(boolean consumeTapEvents) {
        this.consumeTapEvents = consumeTapEvents;
        this.polygon.setClickable(consumeTapEvents);
    }

    @Override
    public void setFillColor(int color) {
        this.polygon.setFillColor(color);
    }

    @Override
    public void setStrokeColor(int color) {
        this.polygon.setStrokeColor(color);
    }

    @Override
    public void setGeodesic(boolean geodesic) {
        this.polygon.setGeodesic(geodesic);
    }

    @Override
    public void setPoints(List<LatLng> points) {
        this.polygon.setPoints(points);
    }

    @Override
    public void setHoles(List<List<LatLng>> holes) {
        this.polygon.setHoles(holes);
    }

    @Override
    public void setVisible(boolean visible) {
        this.polygon.setVisible(visible);
    }

    @Override
    public void setStrokeWidth(float width) {
        this.polygon.setStrokeWidth(width * this.density);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.polygon.setZIndex(zIndex);
    }

    String getGoogleMapsPolygonId() {
        return this.googleMapsPolygonId;
    }

    boolean consumeTapEvents() {
        return this.consumeTapEvents;
    }
}

