/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.TileProvider;
import com.google.maps.android.heatmaps.HeatmapTileProvider;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.HeatmapBuilder;
import io.flutter.plugins.googlemaps.HeatmapController;
import io.flutter.plugins.googlemaps.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HeatmapsController {
    private final Map<String, HeatmapController> heatmapIdToController = new HashMap<String, HeatmapController>();
    private GoogleMap googleMap;

    HeatmapsController() {
    }

    void setGoogleMap(GoogleMap googleMap) {
        this.googleMap = googleMap;
    }

    void addHeatmaps(@NonNull List<Messages.PlatformHeatmap> heatmapsToAdd) {
        for (Messages.PlatformHeatmap heatmapToAdd : heatmapsToAdd) {
            this.addJsonHeatmap(heatmapToAdd.getJson());
        }
    }

    void changeHeatmaps(@NonNull List<Messages.PlatformHeatmap> heatmapsToChange) {
        for (Messages.PlatformHeatmap heatmapToChange : heatmapsToChange) {
            this.changeJsonHeatmap(heatmapToChange.getJson());
        }
    }

    void removeHeatmaps(@NonNull List<String> heatmapIdsToRemove) {
        for (String heatmapId : heatmapIdsToRemove) {
            HeatmapController heatmapController = this.heatmapIdToController.remove(heatmapId);
            if (heatmapController == null) continue;
            heatmapController.remove();
            this.heatmapIdToController.remove(heatmapId);
        }
    }

    @VisibleForTesting
    @NonNull
    public HeatmapTileProvider buildHeatmap(@NonNull HeatmapBuilder builder) {
        return builder.build();
    }

    private void addJsonHeatmap(Map<String, ?> heatmap) {
        if (heatmap == null) {
            return;
        }
        HeatmapBuilder heatmapBuilder = new HeatmapBuilder();
        String heatmapId = Convert.interpretHeatmapOptions(heatmap, heatmapBuilder);
        HeatmapTileProvider options = this.buildHeatmap(heatmapBuilder);
        this.addHeatmap(heatmapId, options);
    }

    private void addHeatmap(String heatmapId, HeatmapTileProvider options) {
        TileOverlay heatmapTileOverlay = this.googleMap.addTileOverlay(new TileOverlayOptions().tileProvider((TileProvider)options));
        HeatmapController heatmapController = new HeatmapController(options, heatmapTileOverlay);
        this.heatmapIdToController.put(heatmapId, heatmapController);
    }

    private void changeJsonHeatmap(Map<String, ?> heatmap) {
        if (heatmap == null) {
            return;
        }
        String heatmapId = HeatmapsController.getHeatmapId(heatmap);
        HeatmapController heatmapController = this.heatmapIdToController.get(heatmapId);
        if (heatmapController != null) {
            Convert.interpretHeatmapOptions(heatmap, heatmapController);
            heatmapController.clearTileCache();
        }
    }

    private static String getHeatmapId(Map<String, ?> heatmap) {
        return (String)heatmap.get("heatmapId");
    }
}

