/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.LatLng;
import io.flutter.plugins.googlemaps.CircleOptionsSink;

class CircleBuilder
implements CircleOptionsSink {
    private final CircleOptions circleOptions = new CircleOptions();
    private final float density;
    private boolean consumeTapEvents;

    CircleBuilder(float density) {
        this.density = density;
    }

    CircleOptions build() {
        return this.circleOptions;
    }

    boolean consumeTapEvents() {
        return this.consumeTapEvents;
    }

    @Override
    public void setFillColor(int color) {
        this.circleOptions.fillColor(color);
    }

    @Override
    public void setStrokeColor(int color) {
        this.circleOptions.strokeColor(color);
    }

    @Override
    public void setCenter(LatLng center) {
        this.circleOptions.center(center);
    }

    @Override
    public void setRadius(double radius) {
        this.circleOptions.radius(radius);
    }

    @Override
    public void setConsumeTapEvents(boolean consumeTapEvents) {
        this.consumeTapEvents = consumeTapEvents;
        this.circleOptions.clickable(consumeTapEvents);
    }

    @Override
    public void setVisible(boolean visible) {
        this.circleOptions.visible(visible);
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.circleOptions.strokeWidth(strokeWidth * this.density);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.circleOptions.zIndex(zIndex);
    }
}

