/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.ClusterManager;
import com.google.maps.android.clustering.view.DefaultClusterRenderer;
import com.google.maps.android.collections.MarkerManager;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.MarkerBuilder;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.NoOpVoidResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClusterManagersController
implements GoogleMap.OnCameraIdleListener,
ClusterManager.OnClusterClickListener<MarkerBuilder> {
    @NonNull
    private final Context context;
    @NonNull
    private final HashMap<String, ClusterManager<MarkerBuilder>> clusterManagerIdToManager = new HashMap();
    @NonNull
    private final Messages.MapsCallbackApi flutterApi;
    @Nullable
    private MarkerManager markerManager;
    @Nullable
    private GoogleMap googleMap;
    @Nullable
    private ClusterManager.OnClusterItemClickListener<MarkerBuilder> clusterItemClickListener;
    @Nullable
    private OnClusterItemRendered<MarkerBuilder> clusterItemRenderedListener;

    ClusterManagersController(@NonNull Messages.MapsCallbackApi flutterApi, Context context) {
        this.context = context;
        this.flutterApi = flutterApi;
    }

    void init(GoogleMap googleMap, MarkerManager markerManager) {
        this.markerManager = markerManager;
        this.googleMap = googleMap;
    }

    void setClusterItemClickListener(@Nullable ClusterManager.OnClusterItemClickListener<MarkerBuilder> listener) {
        this.clusterItemClickListener = listener;
        this.initListenersForClusterManagers();
    }

    void setClusterItemRenderedListener(@Nullable OnClusterItemRendered<MarkerBuilder> listener) {
        this.clusterItemRenderedListener = listener;
    }

    private void initListenersForClusterManagers() {
        for (Map.Entry<String, ClusterManager<MarkerBuilder>> entry : this.clusterManagerIdToManager.entrySet()) {
            this.initListenersForClusterManager(entry.getValue(), this, this.clusterItemClickListener);
        }
    }

    private void initListenersForClusterManager(ClusterManager<MarkerBuilder> clusterManager, @Nullable ClusterManager.OnClusterClickListener<MarkerBuilder> clusterClickListener, @Nullable ClusterManager.OnClusterItemClickListener<MarkerBuilder> clusterItemClickListener) {
        clusterManager.setOnClusterClickListener(clusterClickListener);
        clusterManager.setOnClusterItemClickListener(clusterItemClickListener);
    }

    void addClusterManagers(@NonNull List<Messages.PlatformClusterManager> clusterManagersToAdd) {
        for (Messages.PlatformClusterManager clusterToAdd : clusterManagersToAdd) {
            this.addClusterManager(clusterToAdd.getIdentifier());
        }
    }

    void addClusterManager(String clusterManagerId) {
        ClusterManager clusterManager = new ClusterManager(this.context, this.googleMap, this.markerManager);
        ClusterRenderer clusterRenderer = new ClusterRenderer(this.context, this.googleMap, clusterManager, this);
        clusterManager.setRenderer(clusterRenderer);
        this.initListenersForClusterManager((ClusterManager<MarkerBuilder>)clusterManager, this, this.clusterItemClickListener);
        this.clusterManagerIdToManager.put(clusterManagerId, (ClusterManager<MarkerBuilder>)clusterManager);
    }

    public void removeClusterManagers(@NonNull List<String> clusterManagerIdsToRemove) {
        for (String clusterManagerId : clusterManagerIdsToRemove) {
            this.removeClusterManager(clusterManagerId);
        }
    }

    private void removeClusterManager(Object clusterManagerId) {
        ClusterManager<MarkerBuilder> clusterManager = this.clusterManagerIdToManager.remove(clusterManagerId);
        if (clusterManager == null) {
            return;
        }
        this.initListenersForClusterManager(clusterManager, null, null);
        clusterManager.clearItems();
        clusterManager.cluster();
    }

    public void addItem(MarkerBuilder item) {
        ClusterManager<MarkerBuilder> clusterManager = this.clusterManagerIdToManager.get(item.clusterManagerId());
        if (clusterManager != null) {
            clusterManager.addItem((ClusterItem)item);
            clusterManager.cluster();
        }
    }

    public void removeItem(MarkerBuilder item) {
        ClusterManager<MarkerBuilder> clusterManager = this.clusterManagerIdToManager.get(item.clusterManagerId());
        if (clusterManager != null) {
            clusterManager.removeItem((ClusterItem)item);
            clusterManager.cluster();
        }
    }

    void onClusterItemRendered(@NonNull MarkerBuilder item, @NonNull Marker marker) {
        if (this.clusterItemRenderedListener != null) {
            this.clusterItemRenderedListener.onClusterItemRendered(item, marker);
        }
    }

    private static String getClusterManagerId(Object clusterManagerData) {
        Map clusterMap = (Map)clusterManagerData;
        return (String)clusterMap.get("clusterManagerId");
    }

    @NonNull
    public Set<? extends Cluster<MarkerBuilder>> getClustersWithClusterManagerId(String clusterManagerId) {
        ClusterManager<MarkerBuilder> clusterManager = this.clusterManagerIdToManager.get(clusterManagerId);
        if (clusterManager == null) {
            throw new Messages.FlutterError("Invalid clusterManagerId", "getClusters called with invalid clusterManagerId:" + clusterManagerId, null);
        }
        return clusterManager.getAlgorithm().getClusters(this.googleMap.getCameraPosition().zoom);
    }

    public void onCameraIdle() {
        for (Map.Entry<String, ClusterManager<MarkerBuilder>> entry : this.clusterManagerIdToManager.entrySet()) {
            entry.getValue().onCameraIdle();
        }
    }

    public boolean onClusterClick(Cluster<MarkerBuilder> cluster) {
        if (cluster.getSize() > 0) {
            MarkerBuilder[] builders = cluster.getItems().toArray(new MarkerBuilder[0]);
            String clusterManagerId = builders[0].clusterManagerId();
            this.flutterApi.onClusterTap(Convert.clusterToPigeon(clusterManagerId, cluster), new NoOpVoidResult());
        }
        return false;
    }

    public static interface OnClusterItemRendered<T extends ClusterItem> {
        public void onClusterItemRendered(@NonNull T var1, @NonNull Marker var2);
    }

    private static class ClusterRenderer<T extends MarkerBuilder>
    extends DefaultClusterRenderer<T> {
        private final ClusterManagersController clusterManagersController;

        public ClusterRenderer(Context context, GoogleMap map, ClusterManager<T> clusterManager, ClusterManagersController clusterManagersController) {
            super(context, map, clusterManager);
            this.clusterManagersController = clusterManagersController;
        }

        protected void onBeforeClusterItemRendered(@NonNull T item, @NonNull MarkerOptions markerOptions) {
            ((MarkerBuilder)item).update(markerOptions);
        }

        protected void onClusterItemRendered(@NonNull T item, @NonNull Marker marker) {
            super.onClusterItemRendered(item, marker);
            this.clusterManagersController.onClusterItemRendered((MarkerBuilder)item, marker);
        }
    }
}

