/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapsSdkInitializedCallback;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.Messages;

final class GoogleMapInitializer
implements OnMapsSdkInitializedCallback,
Messages.MapsInitializerApi {
    private static final String TAG = "GoogleMapInitializer";
    private final Context context;
    private static Messages.Result<Messages.PlatformRendererType> initializationResult;
    private boolean rendererInitialized = false;

    GoogleMapInitializer(Context context, BinaryMessenger binaryMessenger) {
        this.context = context;
        Messages.MapsInitializerApi.setUp(binaryMessenger, this);
    }

    @Override
    public void initializeWithPreferredRenderer(@Nullable Messages.PlatformRendererType type, @NonNull Messages.Result<Messages.PlatformRendererType> result) {
        if (this.rendererInitialized || initializationResult != null) {
            result.error(new Messages.FlutterError("Renderer already initialized", "Renderer initialization called multiple times", null));
        } else {
            initializationResult = result;
            this.initializeWithRendererRequest(Convert.toMapRendererType(type));
        }
    }

    @Override
    public void warmup() {
        Log.i((String)TAG, (String)"Google Maps warmup started.");
        try {
            MapView mv = new MapView(this.context);
            mv.onCreate(null);
            mv.onResume();
            mv.onPause();
            mv.onDestroy();
            Log.i((String)TAG, (String)"Maps warmup complete.");
        }
        catch (Exception e) {
            throw new Messages.FlutterError("Could not warm up", e.toString(), null);
        }
    }

    @VisibleForTesting
    public void initializeWithRendererRequest(@Nullable MapsInitializer.Renderer renderer) {
        MapsInitializer.initialize((Context)this.context, (MapsInitializer.Renderer)renderer, (OnMapsSdkInitializedCallback)this);
    }

    public void onMapsSdkInitialized(@NonNull MapsInitializer.Renderer renderer) {
        this.rendererInitialized = true;
        if (initializationResult != null) {
            switch (renderer) {
                case LATEST: {
                    initializationResult.success(Messages.PlatformRendererType.LATEST);
                    break;
                }
                case LEGACY: {
                    initializationResult.success(Messages.PlatformRendererType.LEGACY);
                    break;
                }
                default: {
                    initializationResult.error(new Messages.FlutterError("Unknown renderer type", "Initialized with unknown renderer type", renderer.name()));
                }
            }
            initializationResult = null;
        }
    }
}

