/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugins.imagepicker.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ImagePickerCache {
    static final String MAP_KEY_PATH_LIST = "pathList";
    static final String MAP_KEY_MAX_WIDTH = "maxWidth";
    static final String MAP_KEY_MAX_HEIGHT = "maxHeight";
    static final String MAP_KEY_IMAGE_QUALITY = "imageQuality";
    static final String MAP_KEY_TYPE = "type";
    static final String MAP_KEY_ERROR = "error";
    private static final String MAP_TYPE_VALUE_IMAGE = "image";
    private static final String MAP_TYPE_VALUE_VIDEO = "video";
    private static final String FLUTTER_IMAGE_PICKER_IMAGE_PATH_KEY = "flutter_image_picker_image_path";
    private static final String SHARED_PREFERENCE_ERROR_CODE_KEY = "flutter_image_picker_error_code";
    private static final String SHARED_PREFERENCE_ERROR_MESSAGE_KEY = "flutter_image_picker_error_message";
    private static final String SHARED_PREFERENCE_MAX_WIDTH_KEY = "flutter_image_picker_max_width";
    private static final String SHARED_PREFERENCE_MAX_HEIGHT_KEY = "flutter_image_picker_max_height";
    private static final String SHARED_PREFERENCE_IMAGE_QUALITY_KEY = "flutter_image_picker_image_quality";
    private static final String SHARED_PREFERENCE_TYPE_KEY = "flutter_image_picker_type";
    private static final String SHARED_PREFERENCE_PENDING_IMAGE_URI_PATH_KEY = "flutter_image_picker_pending_image_uri";
    @VisibleForTesting
    static final String SHARED_PREFERENCES_NAME = "flutter_image_picker_shared_preference";
    @NonNull
    private final Context context;

    ImagePickerCache(@NonNull Context context) {
        this.context = context;
    }

    void saveType(CacheType type) {
        switch (type) {
            case IMAGE: {
                this.setType(MAP_TYPE_VALUE_IMAGE);
                break;
            }
            case VIDEO: {
                this.setType(MAP_TYPE_VALUE_VIDEO);
            }
        }
    }

    private void setType(String type) {
        SharedPreferences prefs = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        prefs.edit().putString(SHARED_PREFERENCE_TYPE_KEY, type).apply();
    }

    void saveDimensionWithOutputOptions(Messages.ImageSelectionOptions options) {
        SharedPreferences prefs = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        if (options.getMaxWidth() != null) {
            editor.putLong(SHARED_PREFERENCE_MAX_WIDTH_KEY, Double.doubleToRawLongBits(options.getMaxWidth()));
        }
        if (options.getMaxHeight() != null) {
            editor.putLong(SHARED_PREFERENCE_MAX_HEIGHT_KEY, Double.doubleToRawLongBits(options.getMaxHeight()));
        }
        editor.putInt(SHARED_PREFERENCE_IMAGE_QUALITY_KEY, options.getQuality().intValue());
        editor.apply();
    }

    void savePendingCameraMediaUriPath(Uri uri) {
        SharedPreferences prefs = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        prefs.edit().putString(SHARED_PREFERENCE_PENDING_IMAGE_URI_PATH_KEY, uri.getPath()).apply();
    }

    String retrievePendingCameraMediaUriPath() {
        SharedPreferences prefs = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return prefs.getString(SHARED_PREFERENCE_PENDING_IMAGE_URI_PATH_KEY, "");
    }

    void saveResult(@Nullable ArrayList<String> path, @Nullable String errorCode, @Nullable String errorMessage) {
        SharedPreferences prefs = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        if (path != null) {
            HashSet<String> imageSet = new HashSet<String>(path);
            editor.putStringSet(FLUTTER_IMAGE_PICKER_IMAGE_PATH_KEY, imageSet);
        }
        if (errorCode != null) {
            editor.putString(SHARED_PREFERENCE_ERROR_CODE_KEY, errorCode);
        }
        if (errorMessage != null) {
            editor.putString(SHARED_PREFERENCE_ERROR_MESSAGE_KEY, errorMessage);
        }
        editor.apply();
    }

    void clear() {
        SharedPreferences prefs = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        prefs.edit().clear().apply();
    }

    Map<String, Object> getCacheMap() {
        Set imagePathList;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean hasData = false;
        SharedPreferences prefs = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        if (prefs.contains(FLUTTER_IMAGE_PICKER_IMAGE_PATH_KEY) && (imagePathList = prefs.getStringSet(FLUTTER_IMAGE_PICKER_IMAGE_PATH_KEY, null)) != null) {
            ArrayList pathList = new ArrayList(imagePathList);
            resultMap.put(MAP_KEY_PATH_LIST, pathList);
            hasData = true;
        }
        if (prefs.contains(SHARED_PREFERENCE_ERROR_CODE_KEY)) {
            Messages.CacheRetrievalError.Builder error = new Messages.CacheRetrievalError.Builder();
            error.setCode(prefs.getString(SHARED_PREFERENCE_ERROR_CODE_KEY, ""));
            hasData = true;
            if (prefs.contains(SHARED_PREFERENCE_ERROR_MESSAGE_KEY)) {
                error.setMessage(prefs.getString(SHARED_PREFERENCE_ERROR_MESSAGE_KEY, ""));
            }
            resultMap.put(MAP_KEY_ERROR, error.build());
        }
        if (hasData) {
            if (prefs.contains(SHARED_PREFERENCE_TYPE_KEY)) {
                String typeValue = prefs.getString(SHARED_PREFERENCE_TYPE_KEY, "");
                resultMap.put(MAP_KEY_TYPE, (Object)(typeValue.equals(MAP_TYPE_VALUE_VIDEO) ? Messages.CacheRetrievalType.VIDEO : Messages.CacheRetrievalType.IMAGE));
            }
            if (prefs.contains(SHARED_PREFERENCE_MAX_WIDTH_KEY)) {
                long maxWidthValue = prefs.getLong(SHARED_PREFERENCE_MAX_WIDTH_KEY, 0L);
                resultMap.put(MAP_KEY_MAX_WIDTH, Double.longBitsToDouble(maxWidthValue));
            }
            if (prefs.contains(SHARED_PREFERENCE_MAX_HEIGHT_KEY)) {
                long maxHeightValue = prefs.getLong(SHARED_PREFERENCE_MAX_HEIGHT_KEY, 0L);
                resultMap.put(MAP_KEY_MAX_HEIGHT, Double.longBitsToDouble(maxHeightValue));
            }
            int imageQuality = prefs.getInt(SHARED_PREFERENCE_IMAGE_QUALITY_KEY, 100);
            resultMap.put(MAP_KEY_IMAGE_QUALITY, imageQuality);
        }
        return resultMap;
    }

    public static enum CacheType {
        IMAGE,
        VIDEO;

    }
}

