/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class Messages {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface UrlLauncherApi {
        @NonNull
        public Boolean canLaunchUrl(@NonNull String var1);

        @NonNull
        public Boolean launchUrl(@NonNull String var1, @NonNull Map<String, String> var2);

        @NonNull
        public Boolean openUrlInApp(@NonNull String var1, @NonNull Boolean var2, @NonNull WebViewOptions var3, @NonNull BrowserOptions var4);

        @NonNull
        public Boolean supportsCustomTabs();

        public void closeWebView();

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable UrlLauncherApi api) {
            UrlLauncherApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable UrlLauncherApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.url_launcher_android.UrlLauncherApi.canLaunchUrl" + messageChannelSuffix, UrlLauncherApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    ArrayList args = (ArrayList)message;
                    String urlArg = (String)args.get(0);
                    try {
                        Boolean output = api.canLaunchUrl(urlArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.url_launcher_android.UrlLauncherApi.launchUrl" + messageChannelSuffix, UrlLauncherApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String urlArg = (String)args.get(0);
                    Map headersArg = (Map)args.get(1);
                    try {
                        Boolean output = api.launchUrl(urlArg, headersArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.url_launcher_android.UrlLauncherApi.openUrlInApp" + messageChannelSuffix, UrlLauncherApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String urlArg = (String)args.get(0);
                    Boolean allowCustomTabArg = (Boolean)args.get(1);
                    WebViewOptions webViewOptionsArg = (WebViewOptions)args.get(2);
                    BrowserOptions browserOptionsArg = (BrowserOptions)args.get(3);
                    try {
                        Boolean output = api.openUrlInApp(urlArg, allowCustomTabArg, webViewOptionsArg, browserOptionsArg);
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.url_launcher_android.UrlLauncherApi.supportsCustomTabs" + messageChannelSuffix, UrlLauncherApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Boolean>();
                    try {
                        Boolean output = api.supportsCustomTabs();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.url_launcher_android.UrlLauncherApi.closeWebView" + messageChannelSuffix, UrlLauncherApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.closeWebView();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class PigeonCodec
    extends StandardMessageCodec {
        public static final PigeonCodec INSTANCE = new PigeonCodec();

        private PigeonCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -127: {
                    return WebViewOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return BrowserOptions.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof WebViewOptions) {
                stream.write(129);
                this.writeValue(stream, ((WebViewOptions)value).toList());
            } else if (value instanceof BrowserOptions) {
                stream.write(130);
                this.writeValue(stream, ((BrowserOptions)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static final class BrowserOptions {
        @NonNull
        private Boolean showTitle;

        @NonNull
        public Boolean getShowTitle() {
            return this.showTitle;
        }

        public void setShowTitle(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"showTitle\" is null.");
            }
            this.showTitle = setterArg;
        }

        BrowserOptions() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BrowserOptions that = (BrowserOptions)o;
            return this.showTitle.equals(that.showTitle);
        }

        public int hashCode() {
            return Objects.hash(this.showTitle);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.showTitle);
            return toListResult;
        }

        @NonNull
        static BrowserOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            BrowserOptions pigeonResult = new BrowserOptions();
            Object showTitle = pigeonVar_list.get(0);
            pigeonResult.setShowTitle((Boolean)showTitle);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean showTitle;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setShowTitle(@NonNull Boolean setterArg) {
                this.showTitle = setterArg;
                return this;
            }

            @NonNull
            public BrowserOptions build() {
                BrowserOptions pigeonReturn = new BrowserOptions();
                pigeonReturn.setShowTitle(this.showTitle);
                return pigeonReturn;
            }
        }
    }

    public static final class WebViewOptions {
        @NonNull
        private Boolean enableJavaScript;
        @NonNull
        private Boolean enableDomStorage;
        @NonNull
        private Map<String, String> headers;

        @NonNull
        public Boolean getEnableJavaScript() {
            return this.enableJavaScript;
        }

        public void setEnableJavaScript(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"enableJavaScript\" is null.");
            }
            this.enableJavaScript = setterArg;
        }

        @NonNull
        public Boolean getEnableDomStorage() {
            return this.enableDomStorage;
        }

        public void setEnableDomStorage(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"enableDomStorage\" is null.");
            }
            this.enableDomStorage = setterArg;
        }

        @NonNull
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(@NonNull Map<String, String> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"headers\" is null.");
            }
            this.headers = setterArg;
        }

        WebViewOptions() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WebViewOptions that = (WebViewOptions)o;
            return this.enableJavaScript.equals(that.enableJavaScript) && this.enableDomStorage.equals(that.enableDomStorage) && this.headers.equals(that.headers);
        }

        public int hashCode() {
            return Objects.hash(this.enableJavaScript, this.enableDomStorage, this.headers);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.enableJavaScript);
            toListResult.add(this.enableDomStorage);
            toListResult.add(this.headers);
            return toListResult;
        }

        @NonNull
        static WebViewOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            WebViewOptions pigeonResult = new WebViewOptions();
            Object enableJavaScript = pigeonVar_list.get(0);
            pigeonResult.setEnableJavaScript((Boolean)enableJavaScript);
            Object enableDomStorage = pigeonVar_list.get(1);
            pigeonResult.setEnableDomStorage((Boolean)enableDomStorage);
            Object headers = pigeonVar_list.get(2);
            pigeonResult.setHeaders((Map)headers);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean enableJavaScript;
            @Nullable
            private Boolean enableDomStorage;
            @Nullable
            private Map<String, String> headers;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEnableJavaScript(@NonNull Boolean setterArg) {
                this.enableJavaScript = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEnableDomStorage(@NonNull Boolean setterArg) {
                this.enableDomStorage = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHeaders(@NonNull Map<String, String> setterArg) {
                this.headers = setterArg;
                return this;
            }

            @NonNull
            public WebViewOptions build() {
                WebViewOptions pigeonReturn = new WebViewOptions();
                pigeonReturn.setEnableJavaScript(this.enableJavaScript);
                pigeonReturn.setEnableDomStorage(this.enableDomStorage);
                pigeonReturn.setHeaders(this.headers);
                return pigeonReturn;
            }
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    static @interface CanIgnoreReturnValue {
    }
}

